/*
 * Copyright (C) 2011 Schlichtherle IT Services
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.schlichtherle.truezip.fs;

import java.util.EventListener;

/**
 * Used to notify implementations that a {@link FsModel file system model} has
 * changed its property {@link FsModel#isTouched() touched}.
 *
 * @author Christian Schlichtherle
 * @version $Id$
 */
public interface FsTouchedListener extends EventListener {

    /**
     * Called whenever the value of the property
     * {@link FsModel#isTouched() touched} has changed
     * in the {@link FsEvent#getSource() source} file system model.
     */
    void touchedChanged(FsEvent event);
}
