/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsEvent;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsTouchedListener;
import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsModelTest {
    @Test
    public void testConstructorWithNull() {
        try {
            new FsModel(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructorWithMountPoint() {
        for (String[] params : new String[][]{{"foo:/bar/"}}) {
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            FsModel model = new FsModel(mountPoint);
            Assert.assertThat((Object)model.getMountPoint(), (Matcher)CoreMatchers.sameInstance((Object)mountPoint));
            Assert.assertThat((Object)model.getMountPoint().getPath(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)model.getParent(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)model.isTouched(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testConstructorWithMountPointAndParent() {
        FsMountPoint parentMountPoint;
        FsMountPoint mountPoint;
        for (String[] params : new String[][]{{"foo:/bar/baz/", "foo:/bar/"}, {"foo:/bar/", "foo:/baz/"}}) {
            mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            parentMountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            FsModel parent = new FsModel(parentMountPoint);
            try {
                new FsModel(mountPoint, parent);
                Assert.fail((String)params[0]);
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
        }
        for (String[] params : new String[][]{{"foo:bar:baz:/boom!/bang!/", "bar:baz:/boom!/", "plonk", "bang/plonk", "foo:bar:baz:/boom!/bang!/plonk"}, {"foo:bar:/baz!/", "bar:/", "boom", "baz/boom", "foo:bar:/baz!/boom"}}) {
            mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            parentMountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            FsEntryName entryName = FsEntryName.create((URI)URI.create(params[2]));
            FsEntryName parentEntryName = FsEntryName.create((URI)URI.create(params[3]));
            FsPath path = FsPath.create((URI)URI.create(params[4]));
            FsModel parent = FsModelTest.newModel(parentMountPoint);
            FsModel model = new FsModel(mountPoint, parent);
            Assert.assertThat((Object)model.getMountPoint(), (Matcher)CoreMatchers.sameInstance((Object)mountPoint));
            Assert.assertThat((Object)model.getParent(), (Matcher)CoreMatchers.sameInstance((Object)parent));
            Assert.assertThat((Object)model.getMountPoint().getPath().resolve(entryName).getEntryName(), (Matcher)CoreMatchers.equalTo((Object)parentEntryName));
            Assert.assertThat((Object)model.getMountPoint().resolve(entryName), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)model.isTouched(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    private static FsModel newModel(FsMountPoint mountPoint) {
        return new FsModel(mountPoint, null == mountPoint.getParent() ? null : FsModelTest.newModel(mountPoint.getParent()));
    }

    @Test
    public void testAddRemoveFileSystemListeners() {
        FsModel model = new FsModel(FsMountPoint.create((URI)URI.create("foo:/")));
        try {
            model.addFileSystemTouchedListener(null);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertThat((Object)model.getFileSystemTouchedListeners(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)model.getFileSystemTouchedListeners().size(), (Matcher)CoreMatchers.is((Object)0));
        Listener listener1 = new Listener(model);
        model.addFileSystemTouchedListener((FsTouchedListener)listener1);
        Assert.assertThat((Object)model.getFileSystemTouchedListeners().size(), (Matcher)CoreMatchers.is((Object)1));
        Listener listener2 = new Listener(model);
        model.addFileSystemTouchedListener((FsTouchedListener)listener2);
        Assert.assertThat((Object)model.getFileSystemTouchedListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        model.getFileSystemTouchedListeners().clear();
        Assert.assertThat((Object)model.getFileSystemTouchedListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        try {
            model.removeFileSystemTouchedListener(null);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertThat((Object)model.getFileSystemTouchedListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        model.removeFileSystemTouchedListener((FsTouchedListener)listener1);
        model.removeFileSystemTouchedListener((FsTouchedListener)listener1);
        Assert.assertThat((Object)model.getFileSystemTouchedListeners().size(), (Matcher)CoreMatchers.is((Object)1));
        model.removeFileSystemTouchedListener((FsTouchedListener)listener2);
        model.removeFileSystemTouchedListener((FsTouchedListener)listener2);
        Assert.assertThat((Object)model.getFileSystemTouchedListeners().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testNotifyFileSystemListeners() {
        FsModel model = new FsModel(FsMountPoint.create((URI)URI.create("foo:/")));
        Listener listener1 = new Listener(model);
        Listener listener2 = new Listener(model);
        model.setTouched(false);
        Assert.assertThat((Object)listener1.changes, (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)listener2.changes, (Matcher)CoreMatchers.is((Object)0));
        model.setTouched(true);
        Assert.assertThat((Object)listener1.changes, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)listener2.changes, (Matcher)CoreMatchers.is((Object)1));
        model.setTouched(true);
        Assert.assertThat((Object)listener1.changes, (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)listener2.changes, (Matcher)CoreMatchers.is((Object)1));
        model.setTouched(false);
        Assert.assertThat((Object)listener1.changes, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)listener2.changes, (Matcher)CoreMatchers.is((Object)2));
    }

    private static class Listener
    implements FsTouchedListener {
        final FsModel model;
        int changes;

        Listener(FsModel model) {
            this.model = model;
            model.addFileSystemTouchedListener((FsTouchedListener)this);
        }

        public void touchedChanged(FsEvent event) {
            Assert.assertThat((Object)event, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)event.getSource(), (Matcher)CoreMatchers.sameInstance((Object)this.model));
            ++this.changes;
        }
    }
}

