/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsUriModifier;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsPathTest {
    private static final Logger logger = Logger.getLogger(FsPathTest.class.getName());

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"zip:zip:file:/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r"}, {"zip:file:/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r"}, {"file:/f\u00f6\u00f6%20b\u00e4r/f\u00f6\u00f6%20b\u00e4r"}, {"zip:file:/foo!/bar"}, {"file:/foo/bar"}, {"file:/foo/bar"}, {"f\u00f6\u00f6%20b\u00e4r"}, {"f\u00f6\u00f6/b\u00e4r"}, {"f\u00f6\u00f6"}, {"f\u00f6\u00f6?b\u00e4r"}, {""}}) {
            FsPath original = FsPath.create((String)params[0]);
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(original);
            oos.close();
            logger.log(Level.FINE, "Number of serialized bytes: {0}", bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object clone = ois.readObject();
            ois.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            enc.setExceptionListener(listener);
            enc.writeObject(original);
            enc.close();
            logger.log(Level.FINE, bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder dec = new XMLDecoder(bis);
            clone = dec.readObject();
            dec.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() throws URISyntaxException {
        try {
            FsPath.create((String)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsPath((String)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsPath.create((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsPath((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsPath.create((String)null, (FsUriModifier)FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsPath((String)null, FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsPath.create((URI)null, (FsUriModifier)FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsPath((URI)null, FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsPath.create((String)null, (FsUriModifier)FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsPath((String)null, FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsPath.create((URI)null, (FsUriModifier)FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsPath((URI)null, FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsPath((FsMountPoint)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        for (String param : new String[]{"/../foo#boo", "/../foo#", "/../foo", "/./foo", "//foo", "/foo", "/foo/bar", "/foo/bar/", "/", "foo#bar", "#foo", "foo/", "foo//", "foo/.", "foo/./", "foo/..", "foo/../", "foo:bar", "foo:bar:", "foo:bar:/", "foo:bar:/baz", "foo:bar:/baz!", "foo:bar:/baz/", "foo:bar:/baz!//", "foo:bar:/baz!/#", "foo:bar:/baz!/#bang", "foo:bar:/baz!/.", "foo:bar:/baz!/./", "foo:bar:/baz!/..", "foo:bar:/baz!/../", "foo:bar:/baz!/bang/.", "foo:bar:/baz!/bang/./", "foo:bar:/baz!/bang/..", "foo:bar:/baz!/bang/../", "foo:bar:baz:/bang", "foo:bar:baz:/bang!", "foo:bar:baz:/bang/", "foo:bar:baz:/bang!/", "foo:bar:baz:/bang!/boom", "foo:bar:/baz/.!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "foo:bar:/baz/../!/bang/", "foo:bar:/baz/..!/bang/", "foo:bar:/baz/./!/bang/", "foo:bar:/baz/.!/bang/", "foo:bar:/../baz/!/bang/", "foo:bar:/./baz/!/bang/", "foo:bar://baz/!/bang/", "foo:bar://baz!/bang/", "foo:bar:/!/bang/", "foo:bar:/baz/../!/bang", "foo:bar:/baz/..!/bang", "foo:bar:/baz/./!/bang", "foo:bar:/baz/.!/bang", "foo:bar:/../baz/!/bang", "foo:bar:/./baz/!/bang", "foo:bar://baz/!/bang", "foo:bar://baz!/bang", "foo:bar:/!/bang", "foo:bar:/baz/!/", "foo:bar:/baz/?bang!/?plonk", "foo:bar:/baz//!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "//authority/defined"}) {
            URI uri = URI.create(param);
            try {
                FsPath.create((URI)uri);
                Assert.fail((String)param);
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                new FsPath(uri);
                Assert.fail((String)param);
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructorWithValidUri() {
        for (String[] params : new String[][]{{"foo:bar:baz:/b\u00e4%20ng!/b\u00f6%20\u00f6m!/pl\u00f6%20nk", "foo:bar:baz:/b\u00e4%20ng!/b\u00f6%20\u00f6m!/", "pl\u00f6%20nk"}, {"foo:bar:baz:/b\u00e4ng!/b\u00f6\u00f6m!/pl\u00f6nk", "foo:bar:baz:/b\u00e4ng!/b\u00f6\u00f6m!/", "pl\u00f6nk"}, {"foo:bar:baz:/bang!/boom!/plonk", "foo:bar:baz:/bang!/boom!/", "plonk"}, {"foo:bar:baz:/bang!/boom!/", "foo:bar:baz:/bang!/boom!/", ""}, {"foo:bar:/baz!/bang/../", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/bang/..", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/bang", "foo:bar:/baz!/", "bang"}, {"foo:bar:/baz!/./", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/.", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/", "foo:bar:/baz!/", ""}, {"foo:bar:/baz?bang!/?plonk", "foo:bar:/baz?bang!/", "?plonk"}, {"foo:bar:/baz!/bang/..", "foo:bar:/baz!/", ""}, {"foo:bar:/baz!/bang/../", "foo:bar:/baz!/", ""}, {"foo", null, "foo"}, {"foo/..", null, ""}, {"foo/../", null, ""}, {"foo/bar", null, "foo/bar"}, {"foo:/", "foo:/", ""}, {"foo:/bar", "foo:/", "bar"}, {"foo:/bar/", "foo:/", "bar"}, {"foo:/bar//", "foo:/", "bar"}, {"foo:/bar/.", "foo:/", "bar"}, {"foo:/bar/./", "foo:/", "bar"}, {"foo:/bar/..", "foo:/", ""}, {"foo:/bar/../", "foo:/", ""}, {"foo:/bar/baz", "foo:/bar/", "baz"}, {"foo:/bar/baz?bang", "foo:/bar/", "baz?bang"}, {"foo:/bar/baz/", "foo:/bar/", "baz"}, {"foo:/bar/baz/?bang", "foo:/bar/", "baz?bang"}}) {
            FsPath path = FsPath.create((String)params[0], (FsUriModifier)FsUriModifier.CANONICALIZE);
            FsMountPoint mountPoint = null == params[1] ? null : FsMountPoint.create((String)params[1]);
            FsEntryName entryName = FsEntryName.create((String)params[2]);
            this.assertPath(path, mountPoint, entryName);
            path = new FsPath(mountPoint, entryName);
            this.assertPath(path, mountPoint, entryName);
        }
    }

    private void assertPath(FsPath path, FsMountPoint mountPoint, FsEntryName entryName) {
        if (null != mountPoint) {
            Assert.assertThat((Object)path.getUri(), (Matcher)CoreMatchers.equalTo((Object)URI.create(mountPoint.toString() + entryName)));
            Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
        } else {
            Assert.assertThat((Object)path.getUri(), (Matcher)CoreMatchers.equalTo((Object)entryName.getUri()));
            Assert.assertThat((Object)path.getMountPoint(), (Matcher)CoreMatchers.nullValue());
        }
        Assert.assertThat((Object)path.getEntryName().getUri(), (Matcher)CoreMatchers.equalTo((Object)entryName.getUri()));
        Assert.assertThat((Object)path.toString(), (Matcher)CoreMatchers.equalTo((Object)path.getUri().toString()));
        Assert.assertThat((Object)FsPath.create((String)path.getUri().toString()), (Matcher)CoreMatchers.equalTo((Object)path));
        Assert.assertThat((Object)FsPath.create((String)path.getUri().toString()).hashCode(), (Matcher)CoreMatchers.equalTo((Object)path.hashCode()));
    }

    @Test
    public void testSpaces() {
        for (String[] params : new String[][]{{"foo:bar:baz:/%20!/%20/%20!/%20/%20", " ", " / ", " / "}, {"foo:bar:baz:/%20a%20!/%20b%20!/%20c%20", " a ", " b ", " c "}}) {
            FsPath path = FsPath.create((String)params[0]);
            int i = params.length;
            while (0 < --i) {
                Assert.assertThat((Object)path.getEntryName().getPath(), (Matcher)CoreMatchers.equalTo((Object)params[i]));
                path = path.getMountPoint().getPath();
            }
        }
    }

    @Test
    public void testHierarchicalize() {
        for (String[] params : new String[][]{{"foo:bar:/baz!/", "bar:/baz/"}, {"foo:bar:baz:/x/b\u00f6%20m?pl\u00f6%20k!/b\u00e4%20g?z\u00f6%20k!/", "baz:/x/b\u00f6%20m/b\u00e4%20g/?z\u00f6%20k"}, {"bar:baz:/x/b\u00f6%20m?pl\u00f6%20k!/b\u00e4%20g?z\u00f6%20k", "baz:/x/b\u00f6%20m/b\u00e4%20g?z\u00f6%20k"}, {"foo:bar:baz:/x/b\u00f6\u00f6m?pl\u00f6nk!/b\u00e4ng?z\u00f6nk!/", "baz:/x/b\u00f6\u00f6m/b\u00e4ng/?z\u00f6nk"}, {"bar:baz:/x/b\u00f6\u00f6m?pl\u00f6nk!/b\u00e4ng?z\u00f6nk", "baz:/x/b\u00f6\u00f6m/b\u00e4ng?z\u00f6nk"}, {"foo:bar:baz:/boom?plonk!/bang?zonk!/", "baz:/boom/bang/?zonk"}, {"bar:baz:/boom?plonk!/bang?zonk", "baz:/boom/bang?zonk"}, {"bar:baz:/boom?plonk!/?zonk", "baz:/boom/?zonk"}, {"bar:baz:/boom?plonk!/bang", "baz:/boom/bang"}, {"bar:baz:/boom?plonk!/", "baz:/boom/?plonk"}, {"foo:bar:baz:/boom!/bang!/", "baz:/boom/bang/"}, {"bar:baz:/boom!/bang", "baz:/boom/bang"}, {"foo:bar:/baz?boom!/", "bar:/baz/?boom"}, {"bar:/baz?boom", "bar:/baz?boom"}, {"foo:bar:/baz!/", "bar:/baz/"}, {"bar:/baz", "bar:/baz"}, {"foo:/bar/?boom", "foo:/bar/?boom"}, {"bar?boom", "bar?boom"}, {"foo:/bar/", "foo:/bar/"}, {"bar", "bar"}}) {
            FsPath path = FsPath.create((String)params[0]);
            FsPath hierarchical = path.hierarchicalize();
            Assert.assertThat((Object)hierarchical.getUri(), (Matcher)CoreMatchers.equalTo((Object)URI.create(params[1])));
            Assert.assertThat((Object)hierarchical.hierarchicalize(), (Matcher)CoreMatchers.sameInstance((Object)hierarchical));
        }
    }
}

