/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.socket.ByteArrayIOPool;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolService;
import java.io.CharConversionException;
import org.junit.Before;
import org.junit.Test;

public abstract class CharsetArchiveDriverTestCase {
    protected static final IOPoolService POOL_SERVICE = new ByteArrayIOPoolService();
    private static final String TEXT = "fubar";
    private FsCharsetArchiveDriver<?> driver;

    @Before
    public void setUp() {
        this.driver = this.newArchiveDriver(POOL_SERVICE);
    }

    protected abstract FsCharsetArchiveDriver<?> newArchiveDriver(IOPoolService var1);

    @Test
    public final void testAssertEncodable() throws CharConversionException {
        this.driver.assertEncodable(TEXT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testMultithreading() throws Throwable {
        final Object ready = new Object();
        final Object go = new Object();
        class TestThread
        extends Thread {
            Throwable throwable;

            TestThread() {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = go;
                    synchronized (object) {
                        Object object2 = ready;
                        synchronized (object2) {
                            ready.notify();
                        }
                        go.wait(2000L);
                    }
                    for (int i = 0; i < 100000; ++i) {
                        CharsetArchiveDriverTestCase.this.driver.assertEncodable(CharsetArchiveDriverTestCase.TEXT);
                    }
                }
                catch (Throwable t) {
                    this.throwable = t;
                }
            }
        }
        TestThread[] threads = new TestThread[20];
        Object object = ready;
        synchronized (object) {
            for (int i = 0; i < threads.length; ++i) {
                TestThread thread = new TestThread();
                thread.start();
                threads[i] = thread;
                ready.wait(100L);
            }
        }
        object = go;
        synchronized (object) {
            go.notifyAll();
        }
        for (int i = 0; i < threads.length; ++i) {
            TestThread thread = threads[i];
            thread.join();
            Throwable throwable = thread.throwable;
            if (throwable == null) continue;
            throw throwable;
        }
    }

    private static class ByteArrayIOPoolService
    implements IOPoolService {
        private ByteArrayIOPoolService() {
        }

        public IOPool<?> getPool() {
            return new ByteArrayIOPool(2048);
        }
    }
}

