/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumMap;
import java.util.EnumSet;

public class DummyArchiveEntry
implements FsArchiveEntry {
    private final String name;
    private final Entry.Type type;
    private final EnumMap<Entry.Size, Long> sizes = new EnumMap(Entry.Size.class);
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);

    public DummyArchiveEntry(@NonNull String name, @NonNull Entry.Type type, @CheckForNull Entry template) {
        assert (null != name);
        assert (null != type);
        this.name = name;
        this.type = type;
        if (null != template) {
            long value;
            for (Entry.Size size : EnumSet.allOf(Entry.Size.class)) {
                value = template.getSize(size);
                if (-1L == value) continue;
                this.sizes.put(size, value);
            }
            for (Entry.Access access : EnumSet.allOf(Entry.Access.class)) {
                value = template.getTime(access);
                if (-1L == value) continue;
                this.times.put(access, value);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Entry.Type getType() {
        return this.type;
    }

    public long getSize(Entry.Size type) {
        Long size = this.sizes.get(type);
        return null == size ? -1L : size;
    }

    public boolean setSize(Entry.Size type, long value) {
        this.sizes.put(type, value);
        return true;
    }

    public long getTime(Entry.Access type) {
        Long time = this.times.get(type);
        return null == time ? -1L : time;
    }

    public boolean setTime(Entry.Access type, long value) {
        this.times.put(type, value);
        return true;
    }
}

