/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEvent;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsTouchedListener;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class FsModel {
    private final FsMountPoint mountPoint;
    @CheckForNull
    private final FsModel parent;
    private volatile boolean touched;
    private Set<FsTouchedListener> touchedListeners = new LinkedHashSet<FsTouchedListener>();

    public FsModel(FsMountPoint mountPoint) {
        this(mountPoint, null);
    }

    public FsModel(FsMountPoint mountPoint, @CheckForNull FsModel parent) {
        if (!FsModel.equals(mountPoint.getParent(), null == parent ? null : parent.getMountPoint())) {
            throw new IllegalArgumentException("Parent/Member mismatch!");
        }
        this.mountPoint = mountPoint;
        this.parent = parent;
    }

    private static boolean equals(@CheckForNull Object o1, @CheckForNull Object o2) {
        return o1 == o2 || null != o1 && o1.equals(o2);
    }

    public final FsMountPoint getMountPoint() {
        return this.mountPoint;
    }

    @Nullable
    public final FsModel getParent() {
        return this.parent;
    }

    public final boolean isTouched() {
        return this.touched;
    }

    public final void setTouched(boolean newTouched) {
        boolean oldTouched = this.touched;
        this.touched = newTouched;
        if (newTouched != oldTouched) {
            FsEvent event = new FsEvent(this);
            for (FsTouchedListener listener : this.getFileSystemTouchedListeners()) {
                listener.touchedChanged(event);
            }
        }
    }

    final synchronized Set<FsTouchedListener> getFileSystemTouchedListeners() {
        return new LinkedHashSet<FsTouchedListener>(this.touchedListeners);
    }

    public final synchronized void addFileSystemTouchedListener(FsTouchedListener listener) {
        if (null == listener) {
            throw new NullPointerException();
        }
        this.touchedListeners.add(listener);
    }

    public final synchronized void removeFileSystemTouchedListener(@CheckForNull FsTouchedListener listener) {
        this.touchedListeners.remove(listener);
    }

    public final boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof FsModel && this.mountPoint.equals(((FsModel)that).mountPoint);
    }

    public final int hashCode() {
        return this.mountPoint.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + "[mountPoint=" + this.getMountPoint() + ",parent=" + this.getParent() + ",touched=" + this.touched + "]";
    }
}

