/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Comparator;

public class ChainableIOException
extends IOException
implements Cloneable {
    private static final long serialVersionUID = 2203967634187324928L;
    private static int maxPrintExceptions = 3;
    static final Comparator<ChainableIOException> PRIORITY_COMP = new Comparator<ChainableIOException>(){

        @Override
        public int compare(ChainableIOException l, ChainableIOException r) {
            int cmp = l.priority - r.priority;
            return cmp != 0 ? cmp : INDEX_COMP.compare(l, r);
        }
    };
    static final Comparator<ChainableIOException> INDEX_COMP = new Comparator<ChainableIOException>(){

        @Override
        public int compare(ChainableIOException l, ChainableIOException r) {
            return l.index - r.index;
        }
    };
    private ChainableIOException predecessor = this;
    private final int priority;
    private int index;
    int maxIndex;

    public ChainableIOException() {
        this.priority = 0;
    }

    public ChainableIOException(String message) {
        super(message);
        this.priority = 0;
    }

    public ChainableIOException(Throwable cause) {
        super(null == cause ? null : cause.toString());
        super.initCause(cause);
        this.priority = 0;
    }

    public ChainableIOException(String message, Throwable cause) {
        super(message);
        super.initCause(cause);
        this.priority = 0;
    }

    public ChainableIOException(int priority) {
        this.priority = priority;
    }

    public ChainableIOException(String message, int priority) {
        super(message);
        this.priority = priority;
    }

    public ChainableIOException(Throwable cause, int priority) {
        super(null == cause ? null : cause.toString());
        super.initCause(cause);
        this.priority = priority;
    }

    public ChainableIOException(String message, Throwable cause, int priority) {
        super(message);
        super.initCause(cause);
        this.priority = priority;
    }

    public ChainableIOException clone() {
        try {
            return (ChainableIOException)super.clone();
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    @Override
    public ChainableIOException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }

    public final synchronized ChainableIOException initPredecessor(ChainableIOException predecessor) {
        this.setPredecessor(predecessor);
        predecessor = this.getPredecessor();
        if (predecessor != null) {
            this.index = this.maxIndex = predecessor.maxIndex + 1;
        }
        return this;
    }

    private void setPredecessor(ChainableIOException predecessor) {
        if (this.predecessor != this) {
            if (this.predecessor == predecessor) {
                return;
            }
            throw new IllegalStateException("Can't overwrite predecessor!");
        }
        if (predecessor == this) {
            throw new IllegalArgumentException("Can't be predecessor of myself!");
        }
        if (predecessor != null && predecessor.predecessor == predecessor) {
            throw new IllegalArgumentException("The predecessor's predecessor must be initialized in order to inhibit loops!");
        }
        this.predecessor = predecessor;
    }

    public final synchronized ChainableIOException getPredecessor() {
        return this == this.predecessor ? null : this.predecessor;
    }

    public final int getPriority() {
        return this.priority;
    }

    public ChainableIOException sortPriority() {
        return this.sort(PRIORITY_COMP);
    }

    public ChainableIOException sortIndex() {
        return this.sort(INDEX_COMP);
    }

    private ChainableIOException sort(Comparator<ChainableIOException> cmp) {
        ChainableIOException predecessor = this.getPredecessor();
        if (predecessor == null) {
            return this;
        }
        ChainableIOException tail = predecessor.sort(cmp);
        if (tail == predecessor && cmp.compare(this, tail) >= 0) {
            return this;
        }
        return tail.insert(this.clone(), cmp);
    }

    private ChainableIOException insert(ChainableIOException element, Comparator<ChainableIOException> cmp) {
        if (cmp.compare(element, this) >= 0) {
            element.predecessor = this;
            element.maxIndex = Math.max(element.index, this.maxIndex);
            return element;
        }
        ChainableIOException predecessor = this.predecessor;
        assert (predecessor != this);
        ChainableIOException clone = this.clone();
        if (predecessor != null) {
            clone.predecessor = predecessor.insert(element, cmp);
            clone.maxIndex = Math.max(clone.index, clone.predecessor.maxIndex);
        } else {
            element.predecessor = null;
            clone.predecessor = element;
            clone.maxIndex = element.maxIndex;
        }
        return clone;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.printStackTrace(s, ChainableIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintStream s, int maxExceptions) {
        --maxExceptions;
        ChainableIOException predecessor = this.getPredecessor();
        if (null != predecessor) {
            if (maxExceptions > 0) {
                predecessor.printStackTrace(s, maxExceptions);
                s.println("\nFollowed, but not caused by:");
            } else {
                s.println("\nOmitting " + predecessor.getNumExceptions() + " more exception(s) at the start of this list!");
            }
        }
        super.printStackTrace(s);
    }

    private int getNumExceptions() {
        ChainableIOException predecessor = this.getPredecessor();
        return null != predecessor ? predecessor.getNumExceptions() + 1 : 1;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(s, ChainableIOException.getMaxPrintExceptions());
    }

    public void printStackTrace(PrintWriter s, int maxExceptions) {
        --maxExceptions;
        ChainableIOException predecessor = this.getPredecessor();
        if (predecessor != null) {
            if (maxExceptions > 0) {
                predecessor.printStackTrace(s, maxExceptions);
                s.println("\nFollowed, but not caused by:");
            } else {
                s.println("\nOmitting " + predecessor.getNumExceptions() + " more exception(s) at the start of this list!");
            }
        }
        super.printStackTrace(s);
    }

    public static int getMaxPrintExceptions() {
        return maxPrintExceptions;
    }

    public static void setMaxPrintExceptions(int maxPrintExcepions) {
        maxPrintExceptions = maxPrintExcepions;
    }
}

