/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class IOSocket<LT, PT> {
    IOSocket() {
    }

    @NonNull
    public abstract LT getLocalTarget() throws IOException;

    @CheckForNull
    public abstract PT getPeerTarget() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NonNull InputSocket<?> input, @NonNull OutputSocket<?> output) throws IOException {
        InputStream in = input.connect(output).newInputStream();
        OutputStream out = null;
        try {
            out = output.connect(input).newOutputStream();
        }
        finally {
            if (out == null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    throw new InputException(ex);
                }
            }
        }
        Streams.copy(in, out);
    }

    @NonNull
    public String toString() {
        String rts;
        String lts;
        try {
            LT lt = this.getLocalTarget();
            lts = null == lt ? "(null)" : lt.toString();
        }
        catch (IOException ex) {
            lts = "(?)";
        }
        try {
            PT rt = this.getPeerTarget();
            rts = null == rt ? "(null)" : rt.toString();
        }
        catch (IOException ex) {
            rts = "(?)";
        }
        return lts + " <-> " + rts;
    }

    public final boolean equals(@CheckForNull Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

