/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.entry;

import de.schlichtherle.truezip.entry.EntryName;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class EntryNameTest {
    private static final Logger logger = Logger.getLogger(EntryNameTest.class.getName());

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"f\u00f6\u00f6%20b\u00e4r"}, {"f\u00f6\u00f6/b\u00e4r/"}, {"f\u00f6\u00f6/b\u00e4r"}, {"f\u00f6\u00f6/"}, {"f\u00f6\u00f6"}, {"f\u00f6\u00f6?b\u00e4r"}, {"f\u00f6\u00f6#b\u00e4r"}, {"#b\u00e4r"}, {""}, {"/"}, {"/f\u00f6\u00f6"}, {"."}, {"./"}, {".."}, {"../"}, {"/."}, {"/./"}, {"/.."}, {"/../"}}) {
            EntryName original = EntryName.create((String)params[0]);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(original);
            oos.close();
            logger.log(Level.FINE, "Number of serialized bytes: {0}", bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object clone = ois.readObject();
            ois.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            enc.setExceptionListener(listener);
            enc.writeObject(original);
            enc.close();
            logger.log(Level.FINE, bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder dec = new XMLDecoder(bis);
            clone = dec.readObject();
            dec.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() {
        for (String param : new String[]{"foo bar", "foo:bar", "foo:bar:", "foo:bar:/", "foo:bar:/baz", "foo:bar:/baz!", "foo:bar:/baz/", "foo:bar:/baz!//", "foo:bar:/baz!/#", "foo:bar:/baz!/#bang", "foo:bar:/baz!/.", "foo:bar:/baz!/./", "foo:bar:/baz!/..", "foo:bar:/baz!/../", "foo:bar:/baz!/bang/.", "foo:bar:/baz!/bang/./", "foo:bar:/baz!/bang/..", "foo:bar:/baz!/bang/../", "foo:bar:baz:/bang", "foo:bar:baz:/bang!", "foo:bar:baz:/bang/", "foo:bar:baz:/bang!/", "foo:bar:baz:/bang!/boom", "foo:bar:/baz/.!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "foo:bar:/baz/../!/bang/", "foo:bar:/baz/..!/bang/", "foo:bar:/baz/./!/bang/", "foo:bar:/baz/.!/bang/", "foo:bar:/../baz/!/bang/", "foo:bar:/./baz/!/bang/", "foo:bar://baz/!/bang/", "foo:bar://baz!/bang/", "foo:bar:/!/bang/", "foo:bar:/baz/../!/bang", "foo:bar:/baz/..!/bang", "foo:bar:/baz/./!/bang", "foo:bar:/baz/.!/bang", "foo:bar:/../baz/!/bang", "foo:bar:/./baz/!/bang", "foo:bar://baz/!/bang", "foo:bar://baz!/bang", "foo:bar:/!/bang", "foo:bar:/baz/!/", "foo:bar:/baz/?bang!/?plonk", "foo:bar:/baz//!/", "foo:bar:/baz/./!/", "foo:bar:/baz/..!/", "foo:bar:/baz/../!/", "//authority/defined"}) {
            try {
                EntryName.create((String)param);
                Assert.fail((String)param);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            try {
                new EntryName(param);
                Assert.fail((String)param);
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructorWithValidUri() {
        for (String[] params : new String[][]{{"/../foo", "#bar", "/../foo#bar"}, {"/../foo", "#", "/../foo#"}, {"foo", "#bar", "foo#bar"}, {"foo", "#", "foo#"}, {"", "#foo", "#foo"}, {"", "#", "#"}, {"f\u00f6\u00f6/", "?b\u00e4r", "f\u00f6\u00f6/?b\u00e4r"}, {"f\u00f6\u00f6", "?b\u00e4r", "f\u00f6\u00f6?b\u00e4r"}, {"f\u00f6\u00f6/?b\u00e4r", "", "f\u00f6\u00f6/"}, {"f\u00f6\u00f6?b\u00e4r", "", "f\u00f6\u00f6"}, {"f\u00f6\u00f6/?b\u00e4r", "?t\u00fc\u00fc", "f\u00f6\u00f6/?t\u00fc\u00fc"}, {"f\u00f6\u00f6?b\u00e4r", "?t\u00fc\u00fc", "f\u00f6\u00f6?t\u00fc\u00fc"}, {"f\u00f6\u00f6", "", "f\u00f6\u00f6"}, {"/", "f\u00f6\u00f6", "/f\u00f6\u00f6"}, {"", "f\u00f6\u00f6", "f\u00f6\u00f6"}, {"f\u00f6\u00f6/", "b\u00e4r", "f\u00f6\u00f6/b\u00e4r"}, {"f\u00f6\u00f6", "b\u00e4r", "f\u00f6\u00f6/b\u00e4r"}}) {
            EntryName parent = EntryName.create((URI)URI.create(params[0]));
            EntryName member = EntryName.create((URI)URI.create(params[1]));
            EntryName result = new EntryName(parent, member);
            Assert.assertThat((Object)result.getUri(), (Matcher)CoreMatchers.equalTo((Object)URI.create(params[2])));
            Assert.assertThat((Object)EntryName.create((URI)result.getUri()), (Matcher)CoreMatchers.equalTo((Object)result));
        }
    }
}

