/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.EntryFactory;
import de.schlichtherle.truezip.fs.archive.DummyArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveFileSystemTest {
    @Test
    public void testAddRemoveArchiveFileSystemListeners() {
        FsArchiveFileSystem model = FsArchiveFileSystem.newArchiveFileSystem((EntryFactory)new DummyArchiveDriver());
        try {
            model.addFsArchiveFileSystemTouchListener(null);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)0));
        Listener listener1 = new Listener(model);
        model.addFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener1);
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)1));
        Listener listener2 = new Listener(model);
        model.addFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener2);
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        model.getFsArchiveFileSystemTouchListeners().clear();
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        try {
            model.removeFsArchiveFileSystemTouchListener(null);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        model.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener1);
        model.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener1);
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)1));
        model.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener2);
        model.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener2);
        Assert.assertThat((Object)model.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private static class Listener
    implements FsArchiveFileSystemTouchListener<FsArchiveEntry> {
        final FsArchiveFileSystem<?> model;
        int before;
        int after;

        Listener(FsArchiveFileSystem<?> model) {
            this.model = model;
            model.addFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)this);
        }

        public void beforeTouch(FsArchiveFileSystemEvent<?> event) {
            Assert.assertThat(event, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)event.getSource(), (Matcher)CoreMatchers.sameInstance(this.model));
            ++this.before;
        }

        public void afterTouch(FsArchiveFileSystemEvent<?> event) {
            Assert.assertThat(event, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)event.getSource(), (Matcher)CoreMatchers.sameInstance(this.model));
            ++this.after;
        }
    }
}

