/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.ByteArrayIOEntry;
import de.schlichtherle.truezip.socket.ByteArrayIOPool;
import de.schlichtherle.truezip.socket.IOCache;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class IOCacheTest {
    private static final String MOCK_ENTRY_NAME = "mock";
    private static final String MOCK_ENTRY_DATA_READ = "read";
    private static final String MOCK_ENTRY_DATA_WRITE = "write";
    private ByteArrayIOPool pool;

    @Before
    public final void setUp() throws IOException {
        this.pool = new ByteArrayIOPool(5);
    }

    @Test
    public void testCaching() throws IOException {
        for (IOCache.Strategy strategy : new IOCache.Strategy[]{IOCache.Strategy.WRITE_THROUGH, IOCache.Strategy.WRITE_BACK}) {
            IOCache cache = strategy.newCache((IOPool)this.pool);
            ByteArrayIOEntry back = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            back.setData(MOCK_ENTRY_DATA_READ.getBytes());
            cache.configure((InputSocket)new BrokenInputSocket((Entry)back)).configure((OutputSocket)new BrokenOutputSocket((Entry)back));
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            ByteArrayIOEntry front = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            Assert.assertThat((Object)front.getData(), (Matcher)CoreMatchers.nullValue());
            try {
                IOSocket.copy((InputSocket)cache.getInputSocket(), (OutputSocket)front.getOutputSocket());
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)front.getData(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            cache.configure(back.getInputSocket()).configure(back.getOutputSocket());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)front.getData(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            front = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)front.getData(), (Matcher)CoreMatchers.nullValue());
            IOSocket.copy((InputSocket)cache.getInputSocket(), (OutputSocket)front.getOutputSocket());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ.length()));
            front = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            front.setData(MOCK_ENTRY_DATA_WRITE.getBytes());
            cache.configure((InputSocket)new BrokenInputSocket((Entry)back)).configure((OutputSocket)new BrokenOutputSocket((Entry)back));
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ.length()));
            try {
                IOSocket.copy((InputSocket)front.getInputSocket(), (OutputSocket)cache.getOutputSocket());
                if (IOCache.Strategy.WRITE_THROUGH != strategy) {
                    Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
                    cache.flush();
                }
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            cache.configure(back.getInputSocket()).configure(back.getOutputSocket());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            IOSocket.copy((InputSocket)front.getInputSocket(), (OutputSocket)cache.getOutputSocket());
            if (IOCache.Strategy.WRITE_THROUGH != strategy) {
                Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
                cache.flush();
            }
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            back = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            back.setData(MOCK_ENTRY_DATA_READ.getBytes());
            cache.configure((InputSocket)new BrokenInputSocket((Entry)back)).configure((OutputSocket)new BrokenOutputSocket((Entry)back));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            front = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            IOSocket.copy((InputSocket)cache.getInputSocket(), (OutputSocket)front.getOutputSocket());
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            cache.clear();
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            front = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            try {
                IOSocket.copy((InputSocket)cache.getInputSocket(), (OutputSocket)front.getOutputSocket());
                Assert.fail();
            }
            catch (IOException excepted) {
                // empty catch block
            }
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)front.getData(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            cache.configure(back.getInputSocket()).configure(back.getOutputSocket());
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)front.getData(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            IOSocket.copy((InputSocket)cache.getInputSocket(), (OutputSocket)front.getOutputSocket());
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ.length()));
            front = new ByteArrayIOEntry(MOCK_ENTRY_NAME);
            front.setData(MOCK_ENTRY_DATA_WRITE.getBytes());
            cache.configure((InputSocket)new BrokenInputSocket((Entry)back)).configure((OutputSocket)new BrokenOutputSocket((Entry)back));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ.length()));
            try {
                IOSocket.copy((InputSocket)front.getInputSocket(), (OutputSocket)cache.getOutputSocket());
                if (IOCache.Strategy.WRITE_THROUGH != strategy) {
                    Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
                    cache.flush();
                }
                Assert.fail();
            }
            catch (IOException expected) {
                // empty catch block
            }
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            cache.configure(back.getInputSocket()).configure(back.getOutputSocket());
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_READ));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            IOSocket.copy((InputSocket)front.getInputSocket(), (OutputSocket)cache.getOutputSocket());
            if (IOCache.Strategy.WRITE_THROUGH != strategy) {
                Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)0));
                cache.flush();
            }
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)cache.getEntry().getSize(Entry.Size.DATA), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE.length()));
            cache.configure((InputSocket)new BrokenInputSocket((Entry)back)).configure((OutputSocket)new BrokenOutputSocket((Entry)back)).clear();
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)this.pool.getSize(), (Matcher)CoreMatchers.is((Object)0));
            Assert.assertThat((Object)new String(front.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)new String(back.getData()), (Matcher)CoreMatchers.equalTo((Object)MOCK_ENTRY_DATA_WRITE));
            Assert.assertThat((Object)back.getReads(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)back.getWrites(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)cache.getEntry(), (Matcher)CoreMatchers.nullValue());
        }
    }

    private static class BrokenOutputSocket
    extends OutputSocket<Entry> {
        private final Entry entry;

        public BrokenOutputSocket(Entry entry) {
            if (null == entry) {
                throw new NullPointerException();
            }
            this.entry = entry;
        }

        public Entry getLocalTarget() throws IOException {
            return this.entry;
        }

        public OutputStream newOutputStream() throws IOException {
            return new BrokenOutputStream();
        }

        static class BrokenOutputStream
        extends OutputStream {
            BrokenOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                throw new IOException();
            }
        }
    }

    private static class BrokenInputSocket
    extends InputSocket<Entry> {
        private final Entry entry;

        public BrokenInputSocket(Entry entry) {
            if (null == entry) {
                throw new NullPointerException();
            }
            this.entry = entry;
        }

        public Entry getLocalTarget() throws IOException {
            return this.entry;
        }

        public ReadOnlyFile newReadOnlyFile() throws IOException {
            throw new UnsupportedOperationException();
        }

        public InputStream newInputStream() throws IOException {
            return new BrokenInputStream();
        }

        static class BrokenInputStream
        extends InputStream {
            BrokenInputStream() {
            }

            @Override
            public int read() throws IOException {
                throw new IOException();
            }
        }
    }
}

