/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsDecoratingModel;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNotWriteLockedException;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class FsConcurrentModel
extends FsDecoratingModel<FsModel> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public FsConcurrentModel(FsModel model) {
        super(model);
    }

    public final ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    public final ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    public final void assertWriteLockedByCurrentThread() throws FsNotWriteLockedException {
        if (!this.lock.isWriteLockedByCurrentThread()) {
            throw new FsNotWriteLockedException(this);
        }
    }

    public final void assertNotReadLockedByCurrentThread(FsNotWriteLockedException ex) throws FsNotWriteLockedException {
        if (0 < this.lock.getReadHoldCount()) {
            throw new FsNotWriteLockedException(this, ex);
        }
    }
}

