/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.EntryFactory;
import de.schlichtherle.truezip.fs.FsCachingController;
import de.schlichtherle.truezip.fs.FsConcurrentController;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsDefaultArchiveController;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public abstract class FsArchiveDriver<E extends FsArchiveEntry>
extends FsDriver
implements EntryFactory<E> {
    @Override
    public final boolean isFederated() {
        return true;
    }

    public abstract IOPool<?> getPool();

    @Override
    public FsController<?> newController(FsModel model, FsController<?> parent) {
        return new FsConcurrentController(new FsCachingController(new FsDefaultArchiveController(new FsConcurrentModel(model), this, parent, false), this.getPool()));
    }

    public abstract InputShop<E> newInputShop(FsConcurrentModel var1, InputSocket<?> var2) throws IOException;

    public abstract OutputShop<E> newOutputShop(FsConcurrentModel var1, OutputSocket<?> var2, @CheckForNull InputShop<E> var3) throws IOException;

    @CheckForNull
    public Icon getOpenIcon(FsConcurrentModel model) {
        return null;
    }

    @CheckForNull
    public Icon getClosedIcon(FsConcurrentModel model) {
        return null;
    }
}

