/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.entry.EntryFactory;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsUriModifier;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemException;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import de.schlichtherle.truezip.fs.archive.FsReadOnlyArchiveFileSystem;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.Link;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.CharConversionException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
class FsArchiveFileSystem<E extends FsArchiveEntry>
implements Iterable<FsArchiveFileSystemEntry<E>> {
    private final Splitter splitter = new Splitter();
    private final EntryFactory<E> factory;
    private final MasterEntryTable<E> master;
    private boolean touched;
    private LinkedHashSet<FsArchiveFileSystemTouchListener<? super E>> touchListeners = new LinkedHashSet();

    static <AE extends FsArchiveEntry> FsArchiveFileSystem<AE> newArchiveFileSystem(EntryFactory<AE> factory) {
        return new FsArchiveFileSystem<AE>(factory);
    }

    private FsArchiveFileSystem(EntryFactory<E> factory) {
        this.factory = factory;
        FsArchiveFileSystemEntry<E> root = this.newEntryUnchecked(FsEntryName.ROOT, Entry.Type.DIRECTORY, null);
        E rootEntry = root.getEntry();
        for (Entry.Access access : BitField.allOf(Entry.Access.class)) {
            rootEntry.setTime(access, System.currentTimeMillis());
        }
        this.master = FsArchiveFileSystem.newMasterEntryTable(root, 64);
        try {
            this.touch();
        }
        catch (FsArchiveFileSystemException ex) {
            throw new AssertionError((Object)"veto without a listener!?");
        }
    }

    static <E extends FsArchiveEntry> FsArchiveFileSystem<E> newArchiveFileSystem(EntryFactory<E> factory, EntryContainer<E> archive, @CheckForNull Entry rootTemplate, boolean readOnly) {
        return readOnly ? new FsReadOnlyArchiveFileSystem<E>(archive, factory, rootTemplate) : new FsArchiveFileSystem<E>(factory, archive, rootTemplate);
    }

    FsArchiveFileSystem(EntryFactory<E> factory, EntryContainer<E> archive, @CheckForNull Entry rootTemplate) {
        if (null == rootTemplate) {
            throw new NullPointerException();
        }
        if (rootTemplate instanceof FsArchiveFileSystemEntry) {
            throw new IllegalArgumentException();
        }
        this.factory = factory;
        FsArchiveFileSystemEntry<E> root = this.newEntryUnchecked(FsEntryName.ROOT, Entry.Type.DIRECTORY, rootTemplate);
        this.master = FsArchiveFileSystem.newMasterEntryTable(root, (int)((float)archive.getSize() / 0.7f) + 1);
        ArrayList<FsEntryName> names = new ArrayList<FsEntryName>(archive.getSize());
        for (FsArchiveEntry entry : archive) {
            try {
                FsEntryName name = new FsEntryName(new URI(null, null, Paths.cutTrailingSeparators(entry.getName().replace('\\', '/'), '/'), null), FsUriModifier.CANONICALIZE);
                this.master.add(FsArchiveFileSystemEntry.create(name, entry.getType(), entry));
                names.add(name);
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        this.master.add(root);
        for (FsEntryName name : names) {
            this.fix(name);
        }
    }

    private static <E extends FsArchiveEntry> MasterEntryTable<E> newMasterEntryTable(FsArchiveFileSystemEntry<E> root, int initialCapacity) {
        MasterEntryTable master = root.getEntry().getName().endsWith("/") ? new ZipOrTarEntryTable(initialCapacity) : new DefaultEntryTable(initialCapacity);
        master.add(root);
        return master;
    }

    private void fix(FsEntryName name) {
        if (Paths.isRoot(name.getPath())) {
            return;
        }
        this.splitter.split(name);
        FsEntryName parentName = this.splitter.getParentName();
        String memberName = this.splitter.getMemberName();
        FsArchiveFileSystemEntry<E> parent = this.master.get(parentName, Entry.Type.DIRECTORY);
        if (null == parent) {
            parent = this.newEntryUnchecked(parentName, Entry.Type.DIRECTORY, null);
            this.master.add(parent);
        }
        parent.add(memberName);
        this.fix(parentName);
    }

    boolean isReadOnly() {
        return false;
    }

    boolean isTouched() {
        return this.touched;
    }

    private void touch() throws FsArchiveFileSystemException {
        if (this.touched) {
            return;
        }
        FsArchiveFileSystemEvent event = new FsArchiveFileSystemEvent(this);
        Set<FsArchiveFileSystemTouchListener<E>> listeners = this.getFsArchiveFileSystemTouchListeners();
        try {
            for (FsArchiveFileSystemTouchListener fsArchiveFileSystemTouchListener : listeners) {
                fsArchiveFileSystemTouchListener.beforeTouch(event);
            }
        }
        catch (IOException ex) {
            throw new FsArchiveFileSystemException(null, "touch vetoed", ex);
        }
        this.touched = true;
        for (FsArchiveFileSystemTouchListener fsArchiveFileSystemTouchListener : listeners) {
            fsArchiveFileSystemTouchListener.afterTouch(event);
        }
    }

    Set<FsArchiveFileSystemTouchListener<? super E>> getFsArchiveFileSystemTouchListeners() {
        return (Set)this.touchListeners.clone();
    }

    final void addFsArchiveFileSystemTouchListener(FsArchiveFileSystemTouchListener<? super E> listener) {
        if (null == listener) {
            throw new NullPointerException();
        }
        this.touchListeners.add(listener);
    }

    final void removeFsArchiveFileSystemTouchListener(@Nullable FsArchiveFileSystemTouchListener<? super E> listener) {
        this.touchListeners.remove(listener);
    }

    int getSize() {
        return this.master.getSize();
    }

    @Override
    public Iterator<FsArchiveFileSystemEntry<E>> iterator() {
        return this.master.iterator();
    }

    @Nullable
    final FsArchiveFileSystemEntry<E> getEntry(FsEntryName name) {
        assert (null != name);
        FsArchiveFileSystemEntry<E> entry = this.master.get(name, null);
        return null == entry ? null : entry.clone(this);
    }

    private FsArchiveFileSystemEntry<E> newEntryUnchecked(FsEntryName name, Entry.Type type, @CheckForNull Entry template) {
        assert (null != type);
        assert (!Paths.isRoot(name.getPath()) || Entry.Type.DIRECTORY == type);
        assert (!(template instanceof FsArchiveFileSystemEntry));
        try {
            return FsArchiveFileSystemEntry.create(name, type, (FsArchiveEntry)this.factory.newEntry(name.getPath(), type, template));
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private FsArchiveFileSystemEntry<E> newEntryChecked(FsEntryName name, Entry.Type type, @CheckForNull Entry template) throws FsArchiveFileSystemException {
        assert (null != type);
        assert (!Paths.isRoot(name.getPath()) || Entry.Type.DIRECTORY == type);
        assert (!(template instanceof FsArchiveFileSystemEntry));
        try {
            return FsArchiveFileSystemEntry.create(name, type, (FsArchiveEntry)this.factory.newEntry(name.getPath(), type, template));
        }
        catch (CharConversionException ex) {
            throw new FsArchiveFileSystemException(name.toString(), ex);
        }
    }

    final E copy(E entry) {
        try {
            return (E)((FsArchiveEntry)this.factory.newEntry(entry.getName(), entry.getType(), (Entry)entry));
        }
        catch (CharConversionException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public FsArchiveFileSystemOperation<E> mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws FsArchiveFileSystemException {
        if (null == type) {
            throw new NullPointerException();
        }
        if (Entry.Type.FILE != type && Entry.Type.DIRECTORY != type) {
            throw new FsArchiveFileSystemException(name.toString(), "only FILE and DIRECTORY entries are currently supported");
        }
        FsArchiveFileSystemEntry<E> oldEntry = this.master.get(name, null);
        if (null != oldEntry) {
            if (options.get(FsOutputOption.EXCLUSIVE)) {
                throw new FsArchiveFileSystemException(name.toString(), "entry exists already");
            }
            Entry.Type oldEntryType = oldEntry.getType();
            if (oldEntryType != Entry.Type.FILE && oldEntryType != Entry.Type.HYBRID) {
                throw new FsArchiveFileSystemException(name.toString(), "only (hybrid) files can get replaced");
            }
            if (oldEntryType != type) {
                throw new FsArchiveFileSystemException(name.toString(), "entry exists already as a different type");
            }
        }
        while (template instanceof FsArchiveFileSystemEntry) {
            template = ((FsArchiveFileSystemEntry)template).getEntry();
        }
        return new PathLink(name, type, options.get(FsOutputOption.CREATE_PARENTS), template);
    }

    public void unlink(FsEntryName name) throws FsArchiveFileSystemException {
        if (name.isRoot()) {
            throw new FsArchiveFileSystemException(name.toString(), "root directory cannot get unlinked");
        }
        FsArchiveFileSystemEntry<E> entry = this.master.get(name, null);
        if (entry == null) {
            throw new FsArchiveFileSystemException(name.toString(), "archive entry does not exist");
        }
        if (Entry.Type.DIRECTORY == entry.getType() && 0 < entry.getMembers().size()) {
            throw new FsArchiveFileSystemException(name.toString(), "directory is not empty");
        }
        this.touch();
        this.master.remove(name, entry.getType());
        this.splitter.split(name);
        FsEntryName parentName = this.splitter.getParentName();
        FsArchiveFileSystemEntry<E> parent = this.master.get(parentName, Entry.Type.DIRECTORY);
        assert (parent != null) : "The parent directory of \"" + name.toString() + "\" is missing - archive file system is corrupted!";
        boolean ok = parent.remove(this.splitter.getMemberName());
        assert (ok) : "The parent directory of \"" + name.toString() + "\" does not contain this entry - archive file system is corrupted!";
        E ae = parent.getEntry();
        if (ae.getTime(Entry.Access.WRITE) != -1L) {
            ae.setTime(Entry.Access.WRITE, System.currentTimeMillis());
        }
    }

    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws FsArchiveFileSystemException {
        if (0L > value) {
            throw new IllegalArgumentException(name.toString() + " (negative access time)");
        }
        FsArchiveFileSystemEntry<E> entry = this.master.get(name, null);
        if (null == entry) {
            throw new FsArchiveFileSystemException(name.toString(), "archive entry not found");
        }
        this.touch();
        boolean ok = true;
        for (Entry.Access type : types) {
            ok &= entry.getEntry().setTime(type, value);
        }
        return ok;
    }

    public boolean isWritable(FsEntryName name) {
        return !this.isReadOnly();
    }

    public void setReadOnly(FsEntryName name) throws FsArchiveFileSystemException {
        if (!this.isReadOnly()) {
            throw new FsArchiveFileSystemException(name.getPath(), "cannot set read-only state");
        }
    }

    private static final class Splitter {
        private final Paths.Splitter splitter = new Paths.Splitter('/', false);

        private Splitter() {
        }

        final void split(FsEntryName name) {
            this.splitter.split(name.getPath());
        }

        final FsEntryName getParentName() {
            String path = this.splitter.getParentPath();
            try {
                return null == path ? FsEntryName.ROOT : new FsEntryName(new URI(null, null, path, null), FsUriModifier.NULL);
            }
            catch (URISyntaxException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        final String getMemberName() {
            return this.splitter.getMemberName();
        }
    }

    private static abstract class MasterEntryTable<E extends FsArchiveEntry> {
        final Map<String, FsArchiveFileSystemEntry<E>> table;

        MasterEntryTable(int initialCapacity) {
            this.table = new LinkedHashMap<String, FsArchiveFileSystemEntry<E>>(initialCapacity);
        }

        final int getSize() {
            return this.table.size();
        }

        final Iterator<FsArchiveFileSystemEntry<E>> iterator() {
            class ArchiveEntryIterator
            implements Iterator<FsArchiveFileSystemEntry<E>> {
                final Iterator<FsArchiveFileSystemEntry<E>> it;

                ArchiveEntryIterator() {
                    this.it = MasterEntryTable.this.table.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public FsArchiveFileSystemEntry<E> next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
            return new ArchiveEntryIterator();
        }

        abstract void add(FsArchiveFileSystemEntry<E> var1);

        @CheckForNull
        abstract FsArchiveFileSystemEntry<E> get(FsEntryName var1, @CheckForNull Entry.Type var2);

        abstract void remove(FsEntryName var1, @CheckForNull Entry.Type var2);
    }

    private static final class DefaultEntryTable<E extends FsArchiveEntry>
    extends MasterEntryTable<E> {
        DefaultEntryTable(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        void add(FsArchiveFileSystemEntry<E> entry) {
            this.table.put(entry.getName(), entry);
        }

        @Override
        FsArchiveFileSystemEntry<E> get(FsEntryName name, Entry.Type type) {
            return (FsArchiveFileSystemEntry)this.table.get(name.getPath());
        }

        @Override
        void remove(FsEntryName name, Entry.Type type) {
            this.table.remove(name.getPath());
        }
    }

    private static final class ZipOrTarEntryTable<E extends FsArchiveEntry>
    extends MasterEntryTable<E> {
        ZipOrTarEntryTable(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        void add(FsArchiveFileSystemEntry<E> entry) {
            String fsName = entry.getName();
            String aeName = entry.getEntry().getName();
            if (aeName.startsWith(fsName)) {
                this.table.put(aeName, entry);
            } else if (Entry.Type.DIRECTORY == entry.getType()) {
                this.table.put(fsName + '/', entry);
            } else {
                this.table.put(fsName, entry);
            }
        }

        @Override
        FsArchiveFileSystemEntry<E> get(FsEntryName name, Entry.Type type) {
            String path = name.getPath();
            if (null == type) {
                FsArchiveFileSystemEntry file = (FsArchiveFileSystemEntry)this.table.get(path);
                FsArchiveFileSystemEntry directory = (FsArchiveFileSystemEntry)this.table.get(path + '/');
                return null == file ? (null == directory ? null : directory) : (null == directory ? file : new FsArchiveFileSystemEntry.HybridEntry(file.getEntry(), file, directory));
            }
            if (Entry.Type.DIRECTORY == type) {
                return (FsArchiveFileSystemEntry)this.table.get(path + '/');
            }
            return (FsArchiveFileSystemEntry)this.table.get(path);
        }

        @Override
        void remove(FsEntryName name, Entry.Type type) {
            assert (null != type);
            String path = name.getPath();
            this.table.remove(Entry.Type.DIRECTORY == type ? path + '/' : path);
        }
    }

    private static final class SegmentLink<E extends FsArchiveEntry>
    implements Link<FsArchiveFileSystemEntry<E>> {
        final FsEntryName name;
        @CheckForNull
        final String base;
        final FsArchiveFileSystemEntry<E> entry;

        SegmentLink(FsEntryName name, @CheckForNull String base, FsArchiveFileSystemEntry<E> entry) {
            this.name = name;
            this.entry = entry;
            this.base = base;
        }

        @Override
        public FsArchiveFileSystemEntry<E> getTarget() {
            return this.entry;
        }
    }

    private final class PathLink
    implements FsArchiveFileSystemOperation<E> {
        final boolean createParents;
        final SegmentLink<E>[] links;
        long time = -1L;

        PathLink(FsEntryName name, Entry.Type type, @CheckForNull boolean createParents, Entry template) throws FsArchiveFileSystemException {
            this.createParents = createParents;
            this.links = this.newSegmentLinks(name, type, template, 1);
        }

        private SegmentLink<E>[] newSegmentLinks(FsEntryName entryName, Entry.Type entryType, @CheckForNull Entry template, int level) throws FsArchiveFileSystemException {
            SegmentLink[] elements;
            FsArchiveFileSystem.this.splitter.split(entryName);
            FsEntryName parentName = FsArchiveFileSystem.this.splitter.getParentName();
            String memberName = FsArchiveFileSystem.this.splitter.getMemberName();
            FsArchiveFileSystemEntry parentEntry = FsArchiveFileSystem.this.master.get(parentName, null);
            if (parentEntry != null) {
                if (Entry.Type.DIRECTORY != parentEntry.getType()) {
                    throw new FsArchiveFileSystemException(entryName.toString(), "parent entry must be a directory");
                }
                elements = new SegmentLink[level + 1];
                elements[0] = new SegmentLink(parentName, null, parentEntry);
                FsArchiveFileSystemEntry newEntry = FsArchiveFileSystem.this.newEntryChecked(entryName, entryType, template);
                elements[1] = new SegmentLink(entryName, memberName, newEntry);
            } else if (this.createParents) {
                elements = this.newSegmentLinks(parentName, Entry.Type.DIRECTORY, null, level + 1);
                FsArchiveFileSystemEntry newEntry = FsArchiveFileSystem.this.newEntryChecked(entryName, entryType, template);
                elements[elements.length - level] = new SegmentLink(entryName, memberName, newEntry);
            } else {
                throw new FsArchiveFileSystemException(entryName.toString(), "missing parent directory entry");
            }
            return elements;
        }

        @Override
        public void run() throws FsArchiveFileSystemException {
            assert (2 <= this.links.length);
            FsArchiveFileSystem.this.touch();
            int l = this.links.length;
            FsArchiveFileSystemEntry parent = this.links[0].entry;
            for (int i = 1; i < l; ++i) {
                SegmentLink link = this.links[i];
                FsEntryName name = link.name;
                FsArchiveFileSystemEntry entry = link.entry;
                String member = link.base;
                assert (Entry.Type.DIRECTORY == parent.getType());
                FsArchiveFileSystem.this.master.add(entry);
                if (parent.add(member) && -1L != parent.getTime(Entry.Access.WRITE)) {
                    parent.getEntry().setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
                }
                parent = entry;
            }
            Object entry = ((FsArchiveFileSystemEntry)this.getTarget()).getEntry();
            if (-1L == entry.getTime(Entry.Access.WRITE)) {
                entry.setTime(Entry.Access.WRITE, this.getCurrentTimeMillis());
            }
        }

        private long getCurrentTimeMillis() {
            return 0L <= this.time ? this.time : (this.time = System.currentTimeMillis());
        }

        @Override
        public FsArchiveFileSystemEntry<E> getTarget() {
            return this.links[this.links.length - 1].getTarget();
        }
    }
}

