/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsDecoratingEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class FsArchiveFileSystemEntry<E extends FsArchiveEntry>
extends FsDecoratingEntry<E> {
    public static <E extends FsArchiveEntry> FsArchiveFileSystemEntry<E> create(FsEntryName name, Entry.Type type, E entry) {
        return FsArchiveFileSystemEntry.create(name.getPath(), type, entry);
    }

    private static <E extends FsArchiveEntry> FsArchiveFileSystemEntry<E> create(String path, Entry.Type type, E entry) {
        switch (type) {
            case FILE: {
                assert (Entry.Type.FILE == entry.getType());
                return path.equals(entry.getName()) ? new FileEntry<E>(entry) : new NamedFileEntry<E>(entry, path);
            }
            case DIRECTORY: {
                assert (Entry.Type.DIRECTORY == entry.getType());
                return path.equals(entry.getName()) ? new DirectoryEntry<E>(entry) : new NamedDirectoryEntry<E>(entry, path);
            }
            case SPECIAL: {
                return path.equals(entry.getName()) ? (Entry.Type.DIRECTORY == entry.getType() ? new SpecialDirectoryEntry<E>(entry) : new SpecialFileEntry<E>(entry)) : (Entry.Type.DIRECTORY == entry.getType() ? new NamedSpecialDirectoryEntry<E>(entry, path) : new NamedSpecialFileEntry<E>(entry, path));
            }
        }
        throw new UnsupportedOperationException(entry + " (type not supported)");
    }

    private FsArchiveFileSystemEntry(E entry) {
        super(entry);
    }

    FsArchiveFileSystemEntry<E> clone(FsArchiveFileSystem<E> fileSystem) {
        return FsArchiveFileSystemEntry.create(this.getName(), this.getType(), fileSystem.copy((FsArchiveEntry)this.delegate));
    }

    public final E getEntry() {
        return (E)((FsArchiveEntry)this.delegate);
    }

    boolean add(String member) {
        throw new UnsupportedOperationException();
    }

    boolean remove(String member) {
        throw new UnsupportedOperationException();
    }

    /* synthetic */ FsArchiveFileSystemEntry(FsArchiveEntry x0, 1 x1) {
        this(x0);
    }

    static class HybridEntry<E extends FsArchiveEntry>
    extends FsArchiveFileSystemEntry<E> {
        final FsArchiveFileSystemEntry<E> file;
        final FsArchiveFileSystemEntry<E> directory;

        HybridEntry(E delegate, FsArchiveFileSystemEntry<E> file, FsArchiveFileSystemEntry<E> directory) {
            super((FsArchiveEntry)delegate, null);
            this.file = file;
            this.directory = directory;
        }

        @Override
        FsArchiveFileSystemEntry<E> clone(FsArchiveFileSystem<E> fileSystem) {
            return new HybridEntry<FsArchiveEntry>(fileSystem.copy((FsArchiveEntry)this.delegate), this.file, this.directory);
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public Entry.Type getType() {
            return Entry.Type.HYBRID;
        }

        @Override
        public long getSize(Entry.Size type) {
            return this.file.getSize(type);
        }

        @Override
        public long getTime(Entry.Access type) {
            return Math.max(this.file.getTime(type), this.directory.getTime(type));
        }

        @Override
        public Set<String> getMembers() {
            return this.directory.getMembers();
        }
    }

    private static class NamedSpecialDirectoryEntry<E extends FsArchiveEntry>
    extends NamedDirectoryEntry<E> {
        NamedSpecialDirectoryEntry(E entry, String path) {
            super(entry, path);
        }

        @Override
        public Entry.Type getType() {
            return Entry.Type.SPECIAL;
        }
    }

    private static class SpecialDirectoryEntry<E extends FsArchiveEntry>
    extends DirectoryEntry<E> {
        SpecialDirectoryEntry(E entry) {
            super(entry);
        }

        @Override
        public Entry.Type getType() {
            return Entry.Type.SPECIAL;
        }
    }

    private static class NamedDirectoryEntry<E extends FsArchiveEntry>
    extends DirectoryEntry<E> {
        final String path;

        NamedDirectoryEntry(E entry, String path) {
            super(entry);
            assert (!path.equals(entry.getName()));
            this.path = path;
        }

        @Override
        public final String getName() {
            return this.path;
        }
    }

    private static class DirectoryEntry<E extends FsArchiveEntry>
    extends FsArchiveFileSystemEntry<E> {
        Set<String> members = new LinkedHashSet<String>();

        DirectoryEntry(E entry) {
            super((FsArchiveEntry)entry, null);
        }

        @Override
        FsArchiveFileSystemEntry<E> clone(FsArchiveFileSystem<E> fileSystem) {
            DirectoryEntry clone = (DirectoryEntry)super.clone(fileSystem);
            clone.members = Collections.unmodifiableSet(this.members);
            return clone;
        }

        @Override
        public Entry.Type getType() {
            return Entry.Type.DIRECTORY;
        }

        @Override
        public Set<String> getMembers() {
            return this.members;
        }

        @Override
        boolean add(String member) {
            return this.members.add(member);
        }

        @Override
        boolean remove(String member) {
            return this.members.remove(member);
        }
    }

    private static class NamedSpecialFileEntry<E extends FsArchiveEntry>
    extends NamedFileEntry<E> {
        NamedSpecialFileEntry(E entry, String path) {
            super(entry, path);
        }

        @Override
        public Entry.Type getType() {
            return Entry.Type.SPECIAL;
        }
    }

    private static class SpecialFileEntry<E extends FsArchiveEntry>
    extends FileEntry<E> {
        SpecialFileEntry(E entry) {
            super(entry);
        }

        @Override
        public Entry.Type getType() {
            return Entry.Type.SPECIAL;
        }
    }

    private static class NamedFileEntry<E extends FsArchiveEntry>
    extends FileEntry<E> {
        final String path;

        NamedFileEntry(E entry, String path) {
            super(entry);
            assert (!path.equals(entry.getName()));
            this.path = path;
        }

        @Override
        public final String getName() {
            return this.path;
        }
    }

    private static class FileEntry<E extends FsArchiveEntry>
    extends FsArchiveFileSystemEntry<E> {
        FileEntry(E entry) {
            super((FsArchiveEntry)entry, null);
        }

        @Override
        public Entry.Type getType() {
            return Entry.Type.FILE;
        }

        @Override
        public Set<String> getMembers() {
            return null;
        }
    }
}

