/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.io.Paths;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public abstract class FsCharsetArchiveDriver<E extends FsArchiveEntry>
extends FsArchiveDriver<E> {
    private final Charset charset;
    private final ThreadLocalEncoder encoder = new ThreadLocalEncoder();

    protected FsCharsetArchiveDriver(Charset charset) {
        if (null == charset) {
            throw new NullPointerException();
        }
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    protected static String toZipOrTarEntryName(String name, Entry.Type type) {
        return Entry.Type.DIRECTORY == type ? (name.endsWith("/") ? name : name + '/') : Paths.cutTrailingSeparators(name, '/');
    }

    protected final void assertEncodable(String name) throws CharConversionException {
        if (!this.encoder.canEncode(name)) {
            throw new CharConversionException(name + " (illegal characters in entry name)");
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[charset=" + this.getCharset() + ",federated=" + this.isFederated() + ']';
    }

    private final class ThreadLocalEncoder
    extends ThreadLocal<CharsetEncoder> {
        private ThreadLocalEncoder() {
        }

        @Override
        protected CharsetEncoder initialValue() {
            return FsCharsetArchiveDriver.this.getCharset().newEncoder();
        }

        boolean canEncode(CharSequence cs) {
            return ((CharsetEncoder)this.get()).canEncode(cs);
        }
    }
}

