/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.SequentialIOException;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.JointIterator;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public class FsMultiplexedArchiveOutputShop<AE extends FsArchiveEntry>
extends DecoratingOutputShop<AE, OutputShop<AE>> {
    private final IOPool<?> pool;
    private final Map<String, TempEntryOutputStream> temps = new LinkedHashMap<String, TempEntryOutputStream>();
    private boolean busy;

    public FsMultiplexedArchiveOutputShop(OutputShop<AE> output, IOPool<?> pool) {
        super(output);
        this.pool = pool;
    }

    @Override
    public int getSize() {
        return ((OutputShop)this.delegate).getSize() + this.temps.size();
    }

    @Override
    public Iterator<AE> iterator() {
        return new JointIterator(((OutputShop)this.delegate).iterator(), new TempEntriesIterator());
    }

    @Override
    @CheckForNull
    public AE getEntry(String name) {
        FsArchiveEntry entry = (FsArchiveEntry)((OutputShop)this.delegate).getEntry(name);
        if (null != entry) {
            return (AE)entry;
        }
        TempEntryOutputStream out = this.temps.get(name);
        return null == out ? null : (AE)out.getTarget();
    }

    @Override
    public OutputSocket<? extends AE> getOutputSocket(AE entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<AE> {
            final /* synthetic */ FsArchiveEntry val$entry;

            Output() {
                this.val$entry = fsArchiveEntry;
                super(FsMultiplexedArchiveOutputShop.super.getOutputSocket(fsArchiveEntry));
            }

            @Override
            public OutputStream newOutputStream() throws IOException {
                if (FsMultiplexedArchiveOutputShop.this.isBusy()) {
                    IOPool.Entry temp = (IOPool.Entry)FsMultiplexedArchiveOutputShop.this.pool.allocate();
                    IOException cause = null;
                    try {
                        TempEntryOutputStream tempEntryOutputStream = new TempEntryOutputStream(this.getBoundSocket(), temp);
                        return tempEntryOutputStream;
                    }
                    catch (IOException ex) {
                        cause = ex;
                        throw cause;
                    }
                    finally {
                        if (null != cause) {
                            try {
                                temp.release();
                            }
                            catch (IOException ex) {
                                throw (IOException)ex.initCause(cause);
                            }
                        }
                    }
                }
                return new EntryOutputStream(this.getBoundSocket().newOutputStream());
            }
        }
        return new Output();
    }

    public boolean isBusy() {
        return this.busy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        assert (!this.isBusy());
        try {
            this.storeTemps();
            assert (this.temps.isEmpty());
        }
        finally {
            ((OutputShop)this.delegate).close();
        }
    }

    private void storeTemps() throws IOException {
        if (this.isBusy()) {
            return;
        }
        SequentialIOExceptionBuilder<IOException, SequentialIOException> builder = new SequentialIOExceptionBuilder<IOException, SequentialIOException>(IOException.class, SequentialIOException.class);
        Iterator<TempEntryOutputStream> i = this.temps.values().iterator();
        while (i.hasNext()) {
            TempEntryOutputStream out = i.next();
            boolean remove = true;
            try {
                remove = out.store(false);
            }
            catch (InputException ex) {
                builder.warn(ex);
            }
            catch (IOException ex) {
                throw (SequentialIOException)builder.fail(ex);
            }
            finally {
                if (!remove) continue;
                i.remove();
            }
        }
        builder.check();
    }

    private class TempEntryOutputStream
    extends DecoratingOutputStream {
        private final IOPool.Entry<?> temp;
        private final OutputSocket<? extends AE> output;
        private final AE local;
        private final Entry peer;
        private final InputSocket<?> input;
        private boolean closed;

        TempEntryOutputStream(@NonNull OutputSocket<? extends AE> output, final IOPool.Entry<?> temp) throws IOException {
            super(temp.getOutputSocket().newOutputStream());
            this.output = output;
            this.local = (FsArchiveEntry)output.getLocalTarget();
            this.peer = output.getPeerTarget();
            this.temp = temp;
            class ProxyInput
            extends DecoratingInputSocket<Entry> {
                private final Entry target;

                ProxyInput() {
                    super(entry.getInputSocket());
                    this.target = null != TempEntryOutputStream.this.peer ? TempEntryOutputStream.this.peer : temp;
                }

                @Override
                public Entry getLocalTarget() {
                    return this.target;
                }
            }
            this.input = new ProxyInput();
            TempEntryOutputStream old = FsMultiplexedArchiveOutputShop.this.temps.put(this.local.getName(), this);
            if (null != old) {
                old.store(true);
            }
        }

        public AE getTarget() {
            return this.local;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                try {
                    super.close();
                }
                catch (Throwable throwable) {
                    Entry src = (Entry)this.input.getLocalTarget();
                    FsArchiveEntry dst = (FsArchiveEntry)this.output.getLocalTarget();
                    for (Enum type : BitField.allOf(Entry.Size.class)) {
                        if (-1L != dst.getSize((Entry.Size)type)) continue;
                        dst.setSize((Entry.Size)type, src.getSize((Entry.Size)type));
                    }
                    for (Enum type : BitField.allOf(Entry.Access.class)) {
                        if (-1L != dst.getTime((Entry.Access)type)) continue;
                        dst.setTime((Entry.Access)type, src.getTime((Entry.Access)type));
                    }
                    throw throwable;
                }
                Entry src = (Entry)this.input.getLocalTarget();
                FsArchiveEntry dst = (FsArchiveEntry)this.output.getLocalTarget();
                for (Entry.Size size : BitField.allOf(Entry.Size.class)) {
                    if (-1L != dst.getSize(size)) continue;
                    dst.setSize(size, src.getSize(size));
                }
                for (Entry.Access access : BitField.allOf(Entry.Access.class)) {
                    if (-1L != dst.getTime(access)) continue;
                    dst.setTime(access, src.getTime(access));
                }
            }
            finally {
                FsMultiplexedArchiveOutputShop.this.storeTemps();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean store(boolean discard) throws IOException {
            if (discard) {
                assert (this.closed) : "broken archive controller!";
            } else if (!this.closed || FsMultiplexedArchiveOutputShop.this.isBusy()) {
                return false;
            }
            Throwable cause = null;
            try {
                if (!discard) {
                    IOSocket.copy(this.input, this.output);
                }
            }
            finally {
                try {
                    this.temp.release();
                }
                catch (IOException ex) {
                    throw (IOException)ex.initCause(cause);
                }
            }
            return true;
        }
    }

    private class EntryOutputStream
    extends DecoratingOutputStream {
        private boolean closed;

        EntryOutputStream(OutputStream out) {
            super(out);
            FsMultiplexedArchiveOutputShop.this.busy = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            FsMultiplexedArchiveOutputShop.this.busy = false;
            try {
                super.close();
            }
            finally {
                FsMultiplexedArchiveOutputShop.this.storeTemps();
            }
        }
    }

    private class TempEntriesIterator
    implements Iterator<AE> {
        private final Iterator<TempEntryOutputStream> i;

        private TempEntriesIterator() {
            this.i = FsMultiplexedArchiveOutputShop.this.temps.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public AE next() {
            return this.i.next().getTarget();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

