/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.sl;

import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.spi.FsDriverService;
import de.schlichtherle.truezip.util.ServiceLocator;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class FsDriverLocator
implements FsDriverProvider {
    public static final FsDriverLocator SINGLETON = new FsDriverLocator();
    private final Map<FsScheme, FsDriver> drivers;

    private FsDriverLocator() {
        Logger logger = Logger.getLogger(FsDriverLocator.class.getName(), FsDriverLocator.class.getName());
        Iterator<FsDriverService> i = new ServiceLocator(FsDriverLocator.class.getClassLoader()).getServices(FsDriverService.class);
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>();
        if (!i.hasNext()) {
            throw new ServiceConfigurationError("No provider available for " + FsDriverService.class);
        }
        while (i.hasNext()) {
            FsDriverService service = i.next();
            logger.log(Level.CONFIG, "located", service);
            for (Map.Entry<FsScheme, FsDriver> entry : service.get().entrySet()) {
                FsScheme scheme = entry.getKey();
                FsDriver driver = entry.getValue();
                if (null == scheme || null == driver) continue;
                drivers.put(scheme, driver);
                logger.log(Level.CONFIG, "mapped", new Object[]{scheme, driver});
            }
        }
        this.drivers = Collections.unmodifiableMap(drivers);
    }

    @Override
    public Map<FsScheme, FsDriver> get() {
        return this.drivers;
    }
}

