/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public interface Link<T> {
    @Nullable
    public T getTarget();

    public static enum Type {
        STRONG{

            @Override
            public <T> Link<T> newLink(T target) {
                return new StrongLink<T>(target);
            }
        }
        ,
        SOFT{

            @Override
            public <T> Link<T> newLink(T target) {
                return new SoftLink<T>(target);
            }
        }
        ,
        WEAK{

            @Override
            public <T> Link<T> newLink(T target) {
                return new WeakLink<T>(target);
            }
        };


        @NonNull
        public abstract <T> Link<T> newLink(@Nullable T var1);

        private static class WeakLink<T>
        extends WeakReference<T>
        implements Link<T> {
            WeakLink(T target) {
                super(target);
            }

            @Override
            public T getTarget() {
                return this.get();
            }

            public String toString() {
                return this.getClass().getName() + "[target=" + this.getTarget() + ']';
            }
        }

        private static class SoftLink<T>
        extends SoftReference<T>
        implements Link<T> {
            SoftLink(T target) {
                super(target);
            }

            @Override
            public T getTarget() {
                return this.get();
            }

            public String toString() {
                return this.getClass().getName() + "[target=" + this.getTarget() + ']';
            }
        }

        private static class StrongLink<T>
        implements Link<T> {
            private final T target;

            StrongLink(T target) {
                this.target = target;
            }

            @Override
            public T getTarget() {
                return this.target;
            }

            public String toString() {
                return this.getClass().getName() + "[target=" + this.getTarget() + ']';
            }
        }
    }
}

