/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

@DefaultAnnotation(value={NonNull.class})
public interface Link<T> {
    @CheckForNull
    public T getTarget();

    public static enum Type {
        STRONG{

            @Override
            <T> Link<T> newLink(T target, ReferenceQueue<? super T> queue) {
                return new Strong<T>(target);
            }
        }
        ,
        SOFT{

            @Override
            <T> Link<T> newLink(T target, ReferenceQueue<? super T> queue) {
                return new Soft<T>(target, queue);
            }
        }
        ,
        WEAK{

            @Override
            <T> Link<T> newLink(T target, ReferenceQueue<? super T> queue) {
                return new Weak<T>(target, queue);
            }
        }
        ,
        PHANTOM{

            @Override
            public <T> Link<T> newLink(T target, ReferenceQueue<? super T> queue) {
                return new Phantom<T>(target, queue);
            }
        };


        public <T> Link<T> newLink(@CheckForNull T target) {
            return this.newLink(target, null);
        }

        abstract <T> Link<T> newLink(@CheckForNull T var1, ReferenceQueue<? super T> var2);

        private static final class Phantom<T>
        extends PhantomReference<T>
        implements Link<T> {
            Phantom(T target, ReferenceQueue<? super T> queue) {
                super(target, queue);
            }

            @Override
            public T getTarget() {
                return super.get();
            }

            public String toString() {
                return this.getClass().getName() + "[target=" + this.getTarget() + ']';
            }
        }

        private static final class Weak<T>
        extends WeakReference<T>
        implements Link<T> {
            Weak(T target, ReferenceQueue<? super T> queue) {
                super(target, queue);
            }

            @Override
            public T getTarget() {
                return super.get();
            }

            public String toString() {
                return this.getClass().getName() + "[target=" + this.getTarget() + ']';
            }
        }

        private static final class Soft<T>
        extends SoftReference<T>
        implements Link<T> {
            Soft(T target, ReferenceQueue<? super T> queue) {
                super(target, queue);
            }

            @Override
            public T getTarget() {
                return super.get();
            }

            public String toString() {
                return this.getClass().getName() + "[target=" + this.getTarget() + ']';
            }
        }

        private static final class Strong<T>
        implements Link<T> {
            private final T target;

            Strong(T target) {
                this.target = target;
            }

            @Override
            public T getTarget() {
                return this.target;
            }

            public String toString() {
                return this.getClass().getName() + "[target=" + this.getTarget() + ']';
            }
        }
    }
}

