/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsDefaultModel;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import java.net.URI;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsDefaultModelTest {
    @Test
    public void testConstructorWithNull() {
        try {
            new FsDefaultModel(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructorWithMountPoint() {
        for (String[] params : new String[][]{{"foo:/bar/"}}) {
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            FsDefaultModel model = new FsDefaultModel(mountPoint, null);
            Assert.assertThat((Object)model.getMountPoint(), (Matcher)CoreMatchers.sameInstance((Object)mountPoint));
            Assert.assertThat((Object)model.getMountPoint().getPath(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)model.getParent(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)model.isTouched(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test
    public void testConstructorWithMountPointAndParent() {
        FsMountPoint parentMountPoint;
        FsMountPoint mountPoint;
        for (String[] params : new String[][]{{"foo:/bar/baz/", "foo:/bar/"}, {"foo:/bar/", "foo:/baz/"}}) {
            mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            parentMountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            FsDefaultModel parent = new FsDefaultModel(parentMountPoint, null);
            try {
                new FsDefaultModel(mountPoint, (FsModel)parent);
                Assert.fail((String)params[0]);
            }
            catch (RuntimeException expected) {
                // empty catch block
            }
        }
        for (String[] params : new String[][]{{"foo:bar:baz:/boom!/bang!/", "bar:baz:/boom!/", "plonk", "bang/plonk", "foo:bar:baz:/boom!/bang!/plonk"}, {"foo:bar:/baz!/", "bar:/", "boom", "baz/boom", "foo:bar:/baz!/boom"}}) {
            mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            parentMountPoint = FsMountPoint.create((URI)URI.create(params[1]));
            FsEntryName entryName = FsEntryName.create((URI)URI.create(params[2]));
            FsEntryName parentEntryName = FsEntryName.create((URI)URI.create(params[3]));
            FsPath path = FsPath.create((URI)URI.create(params[4]));
            FsModel parent = FsDefaultModelTest.newModel(parentMountPoint);
            FsDefaultModel model = new FsDefaultModel(mountPoint, parent);
            Assert.assertThat((Object)model.getMountPoint(), (Matcher)CoreMatchers.sameInstance((Object)mountPoint));
            Assert.assertThat((Object)model.getParent(), (Matcher)CoreMatchers.sameInstance((Object)parent));
            Assert.assertThat((Object)model.getMountPoint().getPath().resolve(entryName).getEntryName(), (Matcher)CoreMatchers.equalTo((Object)parentEntryName));
            Assert.assertThat((Object)model.getMountPoint().resolve(entryName), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)model.isTouched(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    private static FsModel newModel(FsMountPoint mountPoint) {
        return new FsDefaultModel(mountPoint, null == mountPoint.getParent() ? null : FsDefaultModelTest.newModel(mountPoint.getParent()));
    }
}

