/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDefaultDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.spi.DummyDriverService;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FsManagerTestSuite {
    private final FsCompositeDriver driver = new FsDefaultDriver((FsDriverProvider)new DummyDriverService("file|zip"));
    private FsManager manager;

    @Before
    public void setUp() {
        this.manager = this.newManager();
    }

    @NonNull
    protected abstract FsManager newManager();

    @Test
    public void testGetControllerWithNull() {
        try {
            this.manager.getController(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testForward() {
        for (String[] params : new String[][]{{"zip:file:/\u00f6uter.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/"}, {"zip:file:/f\u00f6o.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/"}}) {
            FsController parent = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.getController(mountPoint, this.driver);
                if (null != parent && null != parent.getParent()) {
                    Assert.assertThat((Object)controller.getParent(), (Matcher)CoreMatchers.sameInstance((Object)parent));
                }
                parent = controller;
            }
            Assert.assertThat((Object)this.manager.getSize(), (Matcher)CoreMatchers.is((Object)params.length));
            parent = null;
            FsManagerTestSuite.gc();
            Assert.assertThat((Object)this.manager.getSize(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void testBackward() {
        for (String[] params : new String[][]{{"zip:zip:zip:file:/\u00f6uter.zip!/inner.zip!/n\u00fcts.zip!/", "zip:zip:file:/\u00f6uter.zip!/inner.zip!/", "zip:file:/\u00f6uter.zip!/"}, {"zip:zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/b\u00e4z.zip!/", "zip:zip:file:/f\u00f6o.zip!/b\u00e4r.zip!/", "zip:file:/f\u00f6o.zip!/"}}) {
            FsController member = null;
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                FsController controller = this.manager.getController(mountPoint, this.driver);
                if (null != member && null != controller.getParent()) {
                    Assert.assertThat((Object)controller, (Matcher)CoreMatchers.sameInstance((Object)member.getParent()));
                }
                member = controller;
            }
            Iterator i = this.manager.iterator();
            for (String param : params) {
                FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(param));
                Assert.assertThat((Object)((FsController)i.next()).getModel().getMountPoint(), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            }
            Assert.assertThat((Object)i.hasNext(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)this.manager.getSize(), (Matcher)CoreMatchers.is((Object)params.length));
            member = null;
            i = null;
            FsManagerTestSuite.gc();
            Assert.assertThat((Object)this.manager.getSize(), (Matcher)CoreMatchers.is((Object)0));
        }
    }

    static void gc() {
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FsManagerTestSuite.class.getName()).log(Level.WARNING, "Current thread was interrupted while waiting!", ex);
        }
    }
}

