/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveDriver;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveEntry;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveEntryContainer;
import de.schlichtherle.truezip.util.UriBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsArchiveFileSystemTest {
    @Test
    public void testListeners() {
        FsArchiveFileSystem fileSystem = FsArchiveFileSystem.newArchiveFileSystem((FsArchiveDriver)new MockArchiveDriver());
        try {
            fileSystem.addFsArchiveFileSystemTouchListener(null);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)0));
        Listener listener1 = new Listener(fileSystem);
        fileSystem.addFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener1);
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)1));
        Listener listener2 = new Listener(fileSystem);
        fileSystem.addFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener2);
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        fileSystem.getFsArchiveFileSystemTouchListeners().clear();
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        try {
            fileSystem.removeFsArchiveFileSystemTouchListener(null);
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)2));
        fileSystem.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener1);
        fileSystem.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener1);
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)1));
        fileSystem.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener2);
        fileSystem.removeFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)listener2);
        Assert.assertThat((Object)fileSystem.getFsArchiveFileSystemTouchListeners().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testPopulation() throws Exception {
        String[][] paramss = new String[][]{{".", ""}, {"\\t:st", null}, {"/test", null}, {"f:ck"}, {"t\u00e4scht"}, {"foo/", "foo"}, {"foo/bar", "foo", "foo/bar"}, {"foo//bar2", "foo", "foo/bar2"}, {"foo/./bar3", "foo", "foo/bar3"}, {"foo/../bar4", "bar4"}, {"foo\\..\\bar5", "bar5"}, {"./bar6", "bar6"}, {".\\bar7", "bar7"}, {"../bar8", null}, {"..\\bar9", null}};
        MockArchiveEntryContainer container = new MockArchiveEntryContainer();
        MockArchiveDriver driver = new MockArchiveDriver();
        for (String[] params : paramss) {
            String aen = params[0];
            Entry.Type type = aen.endsWith("/") ? Entry.Type.DIRECTORY : Entry.Type.FILE;
            MockArchiveEntry ae = (MockArchiveEntry)driver.newEntry(aen, type, null);
            Assert.assertEquals((Object)aen, (Object)ae.getName());
            new MockArchiveEntryContainer.Output(container).getOutputSocket(ae).newOutputStream().close();
            Assert.assertSame((Object)ae, (Object)container.getEntry(aen));
        }
        Assert.assertEquals((long)paramss.length, (long)container.getSize());
        FsArchiveFileSystem fileSystem = FsArchiveFileSystem.newArchiveFileSystem((FsArchiveDriver)driver, (EntryContainer)container, null, (boolean)false);
        assert (paramss.length <= fileSystem.getSize());
        Assert.assertNotNull((Object)fileSystem.getEntry(FsEntryName.ROOT));
        block1: for (String[] params : paramss) {
            String aen = params[0];
            if (1 == params.length) {
                params = new String[]{aen, aen};
            }
            for (int i = 1; i < params.length; ++i) {
                String cen = params[i];
                if (null == cen) continue;
                FsEntryName entryName = new FsEntryName(new UriBuilder().path(cen).getUri());
                Assert.assertEquals((Object)cen, (Object)entryName.getPath());
                Assert.assertEquals((Object)cen, (Object)fileSystem.getEntry(entryName).getName());
            }
            for (FsCovariantEntry ce : fileSystem) {
                for (MockArchiveEntry ae : ce.getEntries()) {
                    if (!aen.equals(ae.getName())) continue;
                    continue block1;
                }
            }
            assert (false) : "No entry found with this name: " + aen;
        }
    }

    private static class Listener
    implements FsArchiveFileSystemTouchListener<FsArchiveEntry> {
        final FsArchiveFileSystem<?> fileSystem;
        int before;
        int after;

        Listener(FsArchiveFileSystem<?> fileSystem) {
            this.fileSystem = fileSystem;
            fileSystem.addFsArchiveFileSystemTouchListener((FsArchiveFileSystemTouchListener)this);
        }

        public void beforeTouch(FsArchiveFileSystemEvent<?> event) {
            Assert.assertThat(event, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)event.getSource(), (Matcher)CoreMatchers.sameInstance(this.fileSystem));
            ++this.before;
        }

        public void afterTouch(FsArchiveFileSystemEvent<?> event) {
            Assert.assertThat(event, (Matcher)CoreMatchers.notNullValue());
            Assert.assertThat((Object)event.getSource(), (Matcher)CoreMatchers.sameInstance(this.fileSystem));
            ++this.after;
        }
    }
}

