/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.mock;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.socket.spi.ByteArrayIOPoolService;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.nio.charset.Charset;

@DefaultAnnotation(value={NonNull.class})
public final class MockArchiveDriver
extends FsCharsetArchiveDriver<MockArchiveEntry> {
    private static final Charset charset = Charset.forName("UTF-8");
    private volatile IOPoolProvider provider;

    public MockArchiveDriver() {
        super(charset);
    }

    protected IOPool<?> getPool() {
        IOPoolProvider provider = this.provider;
        return (null != provider ? provider : (this.provider = new ByteArrayIOPoolService(2048))).get();
    }

    public InputShop<MockArchiveEntry> newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        throw new UnsupportedOperationException();
    }

    public OutputShop<MockArchiveEntry> newOutputShop(FsModel model, OutputSocket<?> output, InputShop<MockArchiveEntry> source) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MockArchiveEntry newEntry(String name, Entry.Type type, Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        return new MockArchiveEntry(MockArchiveDriver.toZipOrTarEntryName((String)name, (Entry.Type)type), type, template);
    }
}

