/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.mock;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.EnumMap;

@DefaultAnnotation(value={NonNull.class})
public final class MockArchiveEntry
implements FsArchiveEntry {
    private final String name;
    private final Entry.Type type;
    private final EnumMap<Entry.Size, Long> sizes = new EnumMap(Entry.Size.class);
    private final EnumMap<Entry.Access, Long> times = new EnumMap(Entry.Access.class);
    @Nullable
    IOPool.Entry<?> io;

    public MockArchiveEntry(String name, Entry.Type type, @CheckForNull Entry template) {
        assert (null != name);
        assert (null != type);
        this.name = name;
        this.type = type;
        if (null != template) {
            long value;
            for (Entry.Size size : ALL_SIZE_SET) {
                value = template.getSize(size);
                if (-1L == value) continue;
                this.sizes.put(size, value);
            }
            for (Entry.Access access : ALL_ACCESS_SET) {
                value = template.getTime(access);
                if (-1L == value) continue;
                this.times.put(access, value);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Entry.Type getType() {
        return this.type;
    }

    public long getSize(Entry.Size type) {
        Long size = this.sizes.get(type);
        return null != size ? size : -1L;
    }

    public boolean setSize(Entry.Size type, long value) {
        this.sizes.put(type, value);
        return true;
    }

    public long getTime(Entry.Access type) {
        Long time = this.times.get(type);
        return null != time ? time : -1L;
    }

    public boolean setTime(Entry.Access type, long value) {
        this.times.put(type, value);
        return true;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getName()).append("[name=").append(this.getName()).append(",type=").append(this.getType());
        for (Entry.Size type : ALL_SIZE_SET) {
            s.append(",size(").append(type).append(")=").append(this.getSize(type));
        }
        for (Entry.Size type : ALL_ACCESS_SET) {
            s.append(",time(").append(type).append(")=").append(this.getTime((Entry.Access)type));
        }
        return s.append("]").toString();
    }
}

