/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.entry;

import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@SuppressWarnings(value={"JCIP_FIELD_ISNT_FINAL_IN_IMMUTABLE_CLASS"})
@DefaultAnnotation(value={NonNull.class})
public class EntryName
implements Serializable,
Comparable<EntryName> {
    private static final long serialVersionUID = 2927354934726235478L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    private URI uri;

    @Deprecated
    public static EntryName create(String uri) {
        try {
            return new EntryName(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static EntryName create(URI uri) {
        try {
            return new EntryName(uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public EntryName(String uri) throws URISyntaxException {
        this.parse(new URI(uri));
    }

    public EntryName(URI uri) throws URISyntaxException {
        this.parse(uri);
    }

    public EntryName(EntryName parent, EntryName member) {
        URI parentUri = parent.uri;
        String parentUriPath = parentUri.getPath();
        URI memberUri = member.uri;
        try {
            this.uri = parentUriPath.isEmpty() ? memberUri : (parentUriPath.endsWith(SEPARATOR) ? parentUri.resolve(memberUri) : (memberUri.getPath().isEmpty() ? new UriBuilder(parentUri).query(memberUri.getQuery()).fragment(memberUri.getFragment()).getUri() : new UriBuilder().path(parentUriPath + '/').getUri().resolve(memberUri)));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
        assert (this.invariants());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.uri.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.parse(new URI(in.readObject().toString()));
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri) throws URISyntaxException {
        if (uri.isAbsolute()) {
            throw new URISyntaxException(EntryName.quote(uri), "Scheme component not allowed");
        }
        if (null != uri.getRawAuthority()) {
            throw new URISyntaxException(EntryName.quote(uri), "Authority component not allowed");
        }
        this.uri = uri;
        assert (this.invariants());
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (!this.toUri().isAbsolute());
        assert (null == this.toUri().getRawAuthority());
        return true;
    }

    public final URI toUri() {
        return this.uri;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final String getPath() {
        return this.uri.getPath();
    }

    @CheckForNull
    public final String getQuery() {
        return this.uri.getQuery();
    }

    @CheckForNull
    public final String getFragment() {
        return this.uri.getFragment();
    }

    public final boolean equals(@CheckForNull Object that) {
        return this == that || that instanceof EntryName && this.uri.equals(((EntryName)that).uri);
    }

    @Override
    public final int compareTo(EntryName that) {
        return this.uri.compareTo(that.uri);
    }

    public final int hashCode() {
        return this.uri.hashCode();
    }

    public final String toString() {
        return this.uri.toString();
    }
}

