/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class FsFederatingController
extends FsDecoratingController<FsModel, FsController<?>> {
    private volatile FsPath path;

    FsFederatingController(@NonNull FsController<?> controller) {
        super(controller);
        assert (null != this.getParent());
    }

    private FsEntryName resolveParent(FsEntryName name) {
        return this.getPath().resolve(name).getEntryName();
    }

    private FsPath getPath() {
        FsPath path = this.path;
        return null != path ? path : (this.path = ((FsModel)this.getModel()).getMountPoint().getPath());
    }

    @Override
    public Icon getOpenIcon() throws IOException {
        try {
            return this.delegate.getOpenIcon();
        }
        catch (FsFalsePositiveException ex) {
            return this.getParent().getOpenIcon();
        }
    }

    @Override
    public Icon getClosedIcon() throws IOException {
        try {
            return this.delegate.getClosedIcon();
        }
        catch (FsFalsePositiveException ex) {
            return this.getParent().getClosedIcon();
        }
    }

    @Override
    public boolean isReadOnly() throws IOException {
        try {
            return this.delegate.isReadOnly();
        }
        catch (FsFalsePositiveException ex) {
            return this.getParent().isReadOnly();
        }
    }

    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        try {
            return this.delegate.getEntry(name);
        }
        catch (FsFalsePositiveException ex) {
            return this.getParent().getEntry(this.resolveParent(name));
        }
    }

    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        try {
            return this.delegate.isReadable(name);
        }
        catch (FsFalsePositiveException ex) {
            return this.getParent().isReadable(this.resolveParent(name));
        }
    }

    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        try {
            return this.delegate.isWritable(name);
        }
        catch (FsFalsePositiveException ex) {
            return this.getParent().isWritable(this.resolveParent(name));
        }
    }

    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        try {
            this.delegate.setReadOnly(name);
        }
        catch (FsFalsePositiveException ex) {
            this.getParent().setReadOnly(this.resolveParent(name));
        }
    }

    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws IOException {
        try {
            return this.delegate.setTime(name, types, value);
        }
        catch (FsFalsePositiveException ex) {
            return this.getParent().setTime(this.resolveParent(name), types, value);
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new Output(name, options, template);
    }

    @Override
    public void mknod(@NonNull FsEntryName name, @NonNull Entry.Type type, @NonNull BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        try {
            this.delegate.mknod(name, type, options, template);
        }
        catch (FsFalsePositiveException ex) {
            this.getParent().mknod(this.resolveParent(name), type, options, template);
        }
    }

    @Override
    public void unlink(FsEntryName name) throws IOException {
        try {
            this.delegate.unlink(name);
        }
        catch (FsFalsePositiveException ex) {
            this.getParent().unlink(this.resolveParent(name));
        }
    }

    private final class Output
    extends DecoratingOutputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsOutputOption> options;
        final Entry template;

        Output(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
            super(FsFederatingController.this.delegate.getOutputSocket(name, options, template));
            this.name = name;
            this.options = options;
            this.template = template;
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            try {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }
            catch (FsFalsePositiveException ex) {
                return (Entry)FsFederatingController.this.getParent().getOutputSocket(FsFederatingController.this.resolveParent(this.name), this.options, this.template).bind(this).getLocalTarget();
            }
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            try {
                return this.getBoundSocket().newOutputStream();
            }
            catch (FsFalsePositiveException ex) {
                return FsFederatingController.this.getParent().getOutputSocket(FsFederatingController.this.resolveParent(this.name), this.options, this.template).bind(this).newOutputStream();
            }
        }
    }

    private final class Input
    extends DecoratingInputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsInputOption> options;

        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsFederatingController.this.delegate.getInputSocket(name, options));
            this.name = name;
            this.options = options;
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            try {
                return (Entry)this.getBoundSocket().getLocalTarget();
            }
            catch (FsFalsePositiveException ex) {
                return (Entry)FsFederatingController.this.getParent().getInputSocket(FsFederatingController.this.resolveParent(this.name), this.options).bind(this).getLocalTarget();
            }
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            try {
                return this.getBoundSocket().newReadOnlyFile();
            }
            catch (FsFalsePositiveException ex) {
                return FsFederatingController.this.getParent().getInputSocket(FsFederatingController.this.resolveParent(this.name), this.options).bind(this).newReadOnlyFile();
            }
        }

        @Override
        public InputStream newInputStream() throws IOException {
            try {
                return this.getBoundSocket().newInputStream();
            }
            catch (FsFalsePositiveException ex) {
                return FsFederatingController.this.getParent().getInputSocket(FsFederatingController.this.resolveParent(this.name), this.options).bind(this).newInputStream();
            }
        }
    }
}

