/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public enum FsUriModifier {
    NULL{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            if (uri.normalize() != uri) {
                throw new URISyntaxException("\"" + uri + "\"", "URI path not in normal form");
            }
            return uri;
        }
    }
    ,
    CANONICALIZE{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            return fix.modify(uri.normalize());
        }
    };


    abstract URI modify(URI var1, PostFix var2) throws URISyntaxException;

    @Immutable
    public static enum PostFix {
        PATH{

            @Override
            URI modify(URI uri) throws URISyntaxException {
                String s;
                int i;
                if (uri.isOpaque()) {
                    return uri;
                }
                if (uri.getRawPath().startsWith("//") && 0 <= (i = (s = uri.getPath()).indexOf(47, 2))) {
                    uri = new UriBuilder(uri).authority(s.substring(2, i)).path(s.substring(i)).getUri();
                }
                while ((s = uri.getPath()).endsWith("/") && 2 <= s.length() && ':' != s.charAt(s.length() - 2)) {
                    uri = new UriBuilder(uri).path(s.substring(0, s.length() - 1)).getUri();
                }
                return uri;
            }
        }
        ,
        MOUNT_POINT{

            @Override
            URI modify(URI uri) {
                return uri;
            }
        }
        ,
        ENTRY_NAME{

            @Override
            URI modify(URI uri) throws URISyntaxException {
                String s;
                if (uri.isOpaque()) {
                    return uri;
                }
                while ((s = uri.getPath()).endsWith("/") && 2 <= s.length() && ':' != s.charAt(s.length() - 2)) {
                    uri = new UriBuilder(uri).path(s.substring(0, s.length() - 1)).getUri();
                }
                return uri;
            }
        };


        abstract URI modify(URI var1) throws URISyntaxException;
    }
}

