/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDefaultDriver;
import de.schlichtherle.truezip.fs.FsDefaultManager;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsManagerTestSuite;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.spi.DummyDriverService;
import de.schlichtherle.truezip.util.Link;
import java.util.HashSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsFilteringManagerTest
extends FsManagerTestSuite {
    @Override
    protected FsManager newManager() {
        return new FsFilteringManager((FsManager)new FsDefaultManager(), FsMountPoint.create((String)"file:/"));
    }

    @Test
    public void testFiltering() {
        for (String[][] params : new String[][][]{{{"tar:zip:file:/foo!/bar!/"}, {"zip:file:/foo!/"}, new String[0]}, {{"file:/foo/bar/"}, {"zip:file:/foo!/"}, new String[0]}, {{"tar:file:/foo!/"}, {"zip:file:/foo!/"}, {"zip:file:/foo!/"}}, {{"zip:file:/foo!/"}, {"zip:file:/foo!/"}, {"zip:file:/foo!/"}}, {{"file:/foo/"}, {"zip:file:/foo!/"}, new String[0]}, {{"file:/"}, {"zip:file:/foo!/"}, {"zip:file:/foo!/"}}}) {
            assert (params[0].length == 1);
            FsDefaultManager manager = new FsDefaultManager(Link.Type.STRONG);
            for (String param : params[1]) {
                manager.getController(FsMountPoint.create((String)param), (FsCompositeDriver)new FsDefaultDriver((FsDriverProvider)new DummyDriverService("file|tar|zip")));
            }
            Assert.assertThat((Object)manager.getSize(), (Matcher)CoreMatchers.is((Object)params[1].length));
            HashSet<FsMountPoint> set = new HashSet<FsMountPoint>();
            for (String param : params[2]) {
                set.add(FsMountPoint.create((String)param));
            }
            FsFilteringManager filter = new FsFilteringManager((FsManager)manager, FsMountPoint.create((String)params[0][0]));
            Assert.assertThat((Object)filter.getSize(), (Matcher)CoreMatchers.is((Object)params[2].length));
            for (FsController controller : filter) {
                Assert.assertTrue((boolean)set.contains(controller.getModel().getMountPoint()));
            }
        }
    }
}

