/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.mock;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.fs.archive.mock.MockArchiveEntry;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.ByteArrayIOPool;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

@DefaultAnnotation(value={NonNull.class})
public class MockArchiveEntryContainer
implements EntryContainer<MockArchiveEntry> {
    private final Map<String, MockArchiveEntry> map = new LinkedHashMap<String, MockArchiveEntry>();
    private final IOPool<?> pool = new ByteArrayIOPool(2048);

    public int getSize() {
        return this.map.size();
    }

    public Iterator<MockArchiveEntry> iterator() {
        return Collections.unmodifiableCollection(this.map.values()).iterator();
    }

    public MockArchiveEntry getEntry(String name) {
        return this.map.get(name);
    }

    public final class Output
    extends MockArchiveEntryContainer
    implements OutputShop<MockArchiveEntry> {
        private boolean closed;

        public OutputSocket<? extends MockArchiveEntry> getOutputSocket(final MockArchiveEntry entry) {
            if (null == entry) {
                throw new NullPointerException();
            }
            class Socket
            extends OutputSocket<MockArchiveEntry> {
                Socket() {
                }

                public MockArchiveEntry getLocalTarget() {
                    return entry;
                }

                public OutputStream newOutputStream() throws IOException {
                    if (Output.this.closed) {
                        throw new IOException("Output shop closed!");
                    }
                    MockArchiveEntryContainer.this.map.put(entry.getName(), entry);
                    IOPool.Entry _io = entry.io;
                    if (null == _io) {
                        entry.io = _io = (IOPool.Entry)MockArchiveEntryContainer.this.pool.allocate();
                    }
                    final IOPool.Entry io = _io;
                    class Stream
                    extends DecoratingOutputStream {
                        Stream() throws IOException {
                            super(entry.getOutputSocket().newOutputStream());
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void close() throws IOException {
                            try {
                                super.close();
                            }
                            finally {
                                for (Entry.Size type : Entry.ALL_SIZE_SET) {
                                    entry.setSize(type, io.getSize(type));
                                }
                                for (Entry.Size type : Entry.ALL_ACCESS_SET) {
                                    entry.setTime((Entry.Access)type, io.getTime((Entry.Access)type));
                                }
                            }
                        }
                    }
                    return new Stream();
                }
            }
            return new Socket();
        }

        public void close() {
            this.closed = true;
        }
    }

    public final class Input
    extends MockArchiveEntryContainer
    implements InputShop<MockArchiveEntry> {
        private boolean closed;

        public InputSocket<? extends MockArchiveEntry> getInputSocket(final String name) {
            if (null == name) {
                throw new NullPointerException();
            }
            class Socket
            extends InputSocket<MockArchiveEntry> {
                Socket() {
                }

                public MockArchiveEntry getLocalTarget() throws IOException {
                    MockArchiveEntry entry = (MockArchiveEntry)MockArchiveEntryContainer.this.map.get(name);
                    if (null == entry) {
                        throw new FileNotFoundException(name + " (entry not found)");
                    }
                    return entry;
                }

                public ReadOnlyFile newReadOnlyFile() throws IOException {
                    if (Input.this.closed) {
                        throw new IOException("Input shop closed!");
                    }
                    return this.getLocalTarget().io.getInputSocket().newReadOnlyFile();
                }

                public InputStream newInputStream() throws IOException {
                    if (Input.this.closed) {
                        throw new IOException("Input shop closed!");
                    }
                    return this.getLocalTarget().io.getInputSocket().newInputStream();
                }
            }
            return new Socket();
        }

        public void close() {
            this.closed = true;
        }
    }
}

