/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDefaultModel;
import de.schlichtherle.truezip.fs.FsFederatingController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.util.Link;
import de.schlichtherle.truezip.util.Links;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FsDefaultManager
extends FsManager {
    private final Map<FsMountPoint, Link<ScheduledModel>> schedulers = new WeakHashMap<FsMountPoint, Link<ScheduledModel>>();
    private final Link.Type optionalScheduleType;
    private static final Comparator<FsController<?>> BOTTOM_UP_COMPARATOR = new Comparator<FsController<?>>(){

        @Override
        public int compare(FsController<?> l, FsController<?> r) {
            return ((FsModel)r.getModel()).getMountPoint().getHierarchicalUri().compareTo(((FsModel)l.getModel()).getMountPoint().getHierarchicalUri());
        }
    };

    public FsDefaultManager() {
        this(Link.Type.WEAK);
    }

    FsDefaultManager(Link.Type optionalScheduleType) {
        assert (null != optionalScheduleType);
        this.optionalScheduleType = optionalScheduleType;
    }

    @Override
    public synchronized FsController<?> getController(FsMountPoint mountPoint, FsCompositeDriver driver) {
        return this.getController(mountPoint, null, driver);
    }

    private FsController<?> getController(FsMountPoint mountPoint, @CheckForNull FsController<?> parent, FsCompositeDriver driver) {
        if (null == mountPoint.getParent()) {
            if (null != parent) {
                throw new IllegalArgumentException("Parent/member mismatch!");
            }
            return driver.newController(new FsDefaultModel(mountPoint, null), null);
        }
        ScheduledModel model = Links.getTarget(this.schedulers.get(mountPoint));
        if (null == model) {
            if (null == parent) {
                parent = this.getController(mountPoint.getParent(), null, driver);
            }
            model = new ScheduledModel(mountPoint, parent, driver);
        }
        return model.controller;
    }

    @Override
    public synchronized int getSize() {
        return this.schedulers.size();
    }

    @Override
    public synchronized Iterator<FsController<?>> iterator() {
        return this.getControllers().iterator();
    }

    private Set<FsController<?>> getControllers() {
        TreeSet snapshot = new TreeSet(BOTTOM_UP_COMPARATOR);
        for (Link<ScheduledModel> link : this.schedulers.values()) {
            ScheduledModel model = Links.getTarget(link);
            FsFederatingController controller = null == model ? null : model.controller;
            if (null == controller) continue;
            snapshot.add(controller);
        }
        return snapshot;
    }

    private final class ScheduledModel
    extends FsDefaultModel {
        final FsFederatingController controller;

        ScheduledModel(@CheckForNull FsMountPoint mountPoint, FsController<?> parent, FsCompositeDriver driver) {
            super(mountPoint, null == parent ? null : (FsModel)parent.getModel());
            this.schedule(false);
            this.controller = new FsFederatingController(driver.newController(this, parent));
        }

        @Override
        public void setTouched(boolean touched) {
            if (touched == super.isTouched()) {
                return;
            }
            super.setTouched(touched);
            this.schedule(touched);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(boolean unconditional) {
            FsDefaultManager fsDefaultManager = FsDefaultManager.this;
            synchronized (fsDefaultManager) {
                FsDefaultManager.this.schedulers.put(this.getMountPoint(), (unconditional ? Link.Type.STRONG : FsDefaultManager.this.optionalScheduleType).newLink(this));
            }
        }
    }
}

