/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCachingController;
import de.schlichtherle.truezip.fs.FsConcurrentController;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsDefaultArchiveController;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import javax.swing.Icon;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public abstract class FsArchiveDriver<E extends FsArchiveEntry>
extends FsDriver {
    public static final BitField<FsOutputOption> NO_OUTPUT_OPTION = BitField.noneOf(FsOutputOption.class);
    public static final BitField<FsInputOption> NO_INPUT_OPTION = BitField.noneOf(FsInputOption.class);

    @Override
    public final boolean isFederated() {
        return true;
    }

    protected abstract IOPool<?> getPool();

    @CheckForNull
    public Icon getOpenIcon(FsModel model) {
        return null;
    }

    @CheckForNull
    public Icon getClosedIcon(FsModel model) {
        return null;
    }

    public InputSocket<?> getInputSocket(FsController<?> controller, FsEntryName name, BitField<FsInputOption> options) {
        return controller.getInputSocket(name, options);
    }

    public OutputSocket<?> getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return controller.getOutputSocket(name, options, template);
    }

    @Override
    public FsController<?> newController(FsModel model, FsController<?> parent) {
        return new FsConcurrentController(new FsCachingController(new FsDefaultArchiveController(new FsConcurrentModel(model), this, parent), this.getPool()));
    }

    public abstract InputShop<E> newInputShop(FsModel var1, InputSocket<?> var2) throws IOException;

    public abstract OutputShop<E> newOutputShop(FsModel var1, OutputSocket<?> var2, @CheckForNull InputShop<E> var3) throws IOException;

    public final E newEntry(String name, Entry.Type type, @CheckForNull Entry template) throws CharConversionException {
        return this.newEntry(name, type, template, NO_OUTPUT_OPTION);
    }

    public abstract E newEntry(String var1, Entry.Type var2, @CheckForNull Entry var3, BitField<FsOutputOption> var4) throws CharConversionException;
}

