/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.sl;

import de.schlichtherle.truezip.fs.FsDefaultManager;
import de.schlichtherle.truezip.fs.FsFailSafeManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsManagerProvider;
import de.schlichtherle.truezip.fs.spi.FsManagerService;
import de.schlichtherle.truezip.util.ServiceLocator;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class FsManagerLocator
implements FsManagerProvider {
    public static final FsManagerLocator SINGLETON = new FsManagerLocator();

    private FsManagerLocator() {
    }

    @Override
    public FsManager get() {
        return Holder.MANAGER;
    }

    private static class Holder {
        static final FsManager MANAGER;

        Holder() {
        }

        static {
            FsManager manager;
            Iterator<FsManagerService> i;
            Logger logger = Logger.getLogger(FsManagerLocator.class.getName(), FsManagerLocator.class.getName());
            ServiceLocator locator = new ServiceLocator(FsManagerLocator.class.getClassLoader());
            FsManagerService service = locator.getService(FsManagerService.class, null);
            if (null == service && (i = locator.getServices(FsManagerService.class)).hasNext()) {
                service = i.next();
            }
            if (null != service) {
                logger.log(Level.CONFIG, "located", service);
                manager = service.get();
                logger.log(Level.CONFIG, "provided", manager);
            } else {
                manager = new FsFailSafeManager(new FsDefaultManager());
                logger.log(Level.CONFIG, "default", manager);
            }
            MANAGER = manager;
        }
    }
}

