/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;

@DefaultAnnotation(value={NonNull.class})
public abstract class DecoratingOutputStream
extends OutputStream {
    @Nullable
    protected OutputStream delegate;

    protected DecoratingOutputStream(@CheckForNull OutputStream out) {
        this.delegate = out;
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.delegate.close();
        }
    }

    public String toString() {
        return this.getClass().getName() + "[delegate=" + this.delegate + ']';
    }
}

