/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.SynchronizedInputStream;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.SynchronizedReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputShop;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.InputClosedException;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.util.ExceptionHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ConcurrentInputShop<E extends Entry>
extends DecoratingInputShop<E, InputShop<E>> {
    private static final String CLASS_NAME = ConcurrentInputShop.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    private final Map<Closeable, Thread> threads = new WeakHashMap<Closeable, Thread>();
    private volatile boolean closed;

    public ConcurrentInputShop(InputShop<E> input) {
        super(input);
    }

    public final synchronized int waitCloseOthers(long timeout) {
        if (this.closed) {
            return 0;
        }
        long start = System.currentTimeMillis();
        int threadStreams = this.threadStreams();
        try {
            while (this.threads.size() > threadStreams) {
                long toWait;
                if (timeout > 0L) {
                    toWait = timeout - (System.currentTimeMillis() - start);
                    if (toWait <= 0L) {
                        break;
                    }
                } else {
                    toWait = 0L;
                }
                System.gc();
                System.runFinalization();
                this.wait(toWait);
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.WARNING, "wait.interrupted", ex);
        }
        return this.threads.size();
    }

    private int threadStreams() {
        Thread thisThread = Thread.currentThread();
        int n = 0;
        for (Thread thread : this.threads.values()) {
            if (thisThread != thread) continue;
            ++n;
        }
        return n;
    }

    public final synchronized <X extends Exception> void closeAll(ExceptionHandler<IOException, X> handler) throws X {
        if (this.closed) {
            return;
        }
        Iterator<Closeable> i = this.threads.keySet().iterator();
        while (i.hasNext()) {
            try {
                Closeable closeable = i.next();
                i.remove();
                closeable.close();
            }
            catch (IOException ex) {
                handler.warn(ex);
            }
        }
        assert (this.threads.isEmpty());
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.threads.isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
    }

    private void assertNotShopClosed() throws IOException {
        if (this.closed) {
            throw new InputClosedException();
        }
    }

    @Override
    public final InputSocket<? extends E> getInputSocket(final String name) {
        if (null == name) {
            throw new NullPointerException();
        }
        class Input
        extends DecoratingInputSocket<E> {
            Input() {
                super(ConcurrentInputShop.super.getInputSocket(string));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputStream newInputStream() throws IOException {
                ConcurrentInputShop concurrentInputShop = ConcurrentInputShop.this;
                synchronized (concurrentInputShop) {
                    ConcurrentInputShop.this.assertNotShopClosed();
                    return new SynchronizedConcurrentInputStream(new ConcurrentInputStream(this.getBoundSocket().newInputStream()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                ConcurrentInputShop concurrentInputShop = ConcurrentInputShop.this;
                synchronized (concurrentInputShop) {
                    ConcurrentInputShop.this.assertNotShopClosed();
                    return new SynchronizedConcurrentReadOnlyFile(new ConcurrentReadOnlyFile(this.getBoundSocket().newReadOnlyFile()));
                }
            }
        }
        return new Input();
    }

    @NotThreadSafe
    private final class ConcurrentReadOnlyFile
    extends DecoratingReadOnlyFile {
        ConcurrentReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public long length() throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.length();
        }

        @Override
        public long getFilePointer() throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.getFilePointer();
        }

        @Override
        public void seek(long pos) throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            this.delegate.seek(pos);
        }

        @Override
        public int read() throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (!ConcurrentInputShop.this.closed) {
                this.delegate.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    @NotThreadSafe
    private final class ConcurrentInputStream
    extends DecoratingInputStream {
        ConcurrentInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            return this.delegate.available();
        }

        @Override
        public void mark(int readlimit) {
            if (!ConcurrentInputShop.this.closed) {
                this.delegate.mark(readlimit);
            }
        }

        @Override
        public void reset() throws IOException {
            ConcurrentInputShop.this.assertNotShopClosed();
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return !ConcurrentInputShop.this.closed && this.delegate.markSupported();
        }

        @Override
        public void close() throws IOException {
            if (!ConcurrentInputShop.this.closed) {
                this.delegate.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    @ThreadSafe
    private final class SynchronizedConcurrentReadOnlyFile
    extends SynchronizedReadOnlyFile {
        private SynchronizedConcurrentReadOnlyFile(ReadOnlyFile rof) {
            super(rof, ConcurrentInputShop.this);
            ConcurrentInputShop.this.threads.put(rof, Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            assert (ConcurrentInputShop.this == this.lock);
            Object object = this.lock;
            synchronized (object) {
                if (ConcurrentInputShop.this.closed) {
                    return;
                }
                try {
                    this.delegate.close();
                }
                finally {
                    ConcurrentInputShop.this.threads.remove(this.delegate);
                    this.lock.notify();
                }
            }
        }
    }

    @ThreadSafe
    private final class SynchronizedConcurrentInputStream
    extends SynchronizedInputStream {
        SynchronizedConcurrentInputStream(InputStream in) {
            super(in, ConcurrentInputShop.this);
            ConcurrentInputShop.this.threads.put(in, Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            assert (ConcurrentInputShop.this == this.lock);
            Object object = this.lock;
            synchronized (object) {
                if (ConcurrentInputShop.this.closed) {
                    return;
                }
                try {
                    this.delegate.close();
                }
                finally {
                    ConcurrentInputShop.this.threads.remove(this.delegate);
                    this.lock.notify();
                }
            }
        }
    }
}

