/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class OutputSocket<E extends Entry>
extends IOSocket<E, Entry> {
    @CheckForNull
    private InputSocket<?> peer;

    @Override
    @Nullable
    public Entry getPeerTarget() throws IOException {
        return null == this.peer ? null : (Entry)this.peer.getLocalTarget();
    }

    public final OutputSocket<E> bind(@CheckForNull OutputSocket<?> to) {
        this.peer = null == to ? null : to.peer;
        return this;
    }

    final OutputSocket<E> connect(@CheckForNull InputSocket<?> newPeer) {
        InputSocket<?> oldPeer = this.peer;
        if (oldPeer != newPeer) {
            this.peer = null;
            if (null != oldPeer) {
                oldPeer.connect(null);
            }
            this.peer = newPeer;
            if (null != newPeer) {
                newPeer.connect(this);
            }
        }
        return this;
    }

    public abstract OutputStream newOutputStream() throws IOException;
}

