/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsPath;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.FsUriModifier;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FsMountPointTest {
    private static final Logger logger = Logger.getLogger(FsMountPoint.class.getName());

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ExceptionListener listener = new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception ex) {
                throw new UndeclaredThrowableException(ex);
            }
        };
        for (String[] params : new String[][]{{"zip:zip:file:/f\u00f6\u00f6%20b\u00e4r!/f\u00f6\u00f6%20b\u00e4r!/"}, {"zip:file:/f\u00f6\u00f6%20b\u00e4r!/"}, {"file:/f\u00f6\u00f6%20b\u00e4r/"}}) {
            FsMountPoint original = FsMountPoint.create((URI)URI.create(params[0]));
            Assert.assertThat((Object)original.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(original);
            oos.close();
            logger.log(Level.FINE, "Number of serialized bytes: {0}", bos.size());
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            Object clone = ois.readObject();
            ois.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
            bos = new ByteArrayOutputStream();
            XMLEncoder enc = new XMLEncoder(bos);
            enc.setExceptionListener(listener);
            enc.writeObject(original);
            enc.close();
            logger.log(Level.FINE, bos.toString("UTF-8"));
            bis = new ByteArrayInputStream(bos.toByteArray());
            XMLDecoder dec = new XMLDecoder(bis);
            clone = dec.readObject();
            dec.close();
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)original)));
            Assert.assertThat((Object)clone, (Matcher)CoreMatchers.equalTo((Object)original));
            Assert.assertThat((Object)clone.toString(), (Matcher)CoreMatchers.equalTo((Object)params[0]));
        }
    }

    @Test
    public void testConstructorWithInvalidUri() throws URISyntaxException {
        try {
            FsMountPoint.create((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((URI)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsMountPoint.create((URI)null, (FsUriModifier)FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((URI)null, FsUriModifier.NULL);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsMountPoint.create((URI)null, (FsUriModifier)FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((URI)null, FsUriModifier.CANONICALIZE);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            FsMountPoint.create((FsScheme)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            new FsMountPoint((FsScheme)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        for (String string : new String[]{"foo:/?queryDefined", "foo:bar:baz:/!/!/", "foo", "foo/bar", "foo/bar/", "/foo", "/foo/bar", "/foo/bar/", "//foo", "/../foo", "foo:/bar#baz", "foo:/bar/#baz", "foo:/bar", "foo:/bar?baz", "foo:/bar//", "foo:/bar/.", "foo:/bar/./", "foo:/bar/..", "foo:/bar/../", "foo:bar!/", "foo:bar:baz!/", "foo:bar:/baz!//", "foo:bar:/baz!/.", "foo:bar:/baz!/./", "foo:bar:/baz!/..", "foo:bar:/baz!/../", "foo:bar:/baz!/bang", "foo:bar:/baz!/#bang", "foo:bar:/baz/!/", "foo:bar:baz:/bang!/!/"}) {
            URI uri = URI.create(string);
            try {
                FsMountPoint.create((URI)uri);
                Assert.fail((String)string);
            }
            catch (IllegalArgumentException expected) {
                // empty catch block
            }
            try {
                new FsMountPoint(uri);
                Assert.fail((String)string);
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
        for (String string : new String[][]{{"foo", "bar:baz:/bang!/"}, {"foo", "bar:/baz/"}}) {
            FsScheme scheme = FsScheme.create((String)string[0]);
            FsPath path = FsPath.create((URI)URI.create(string[1]));
            try {
                new FsMountPoint(scheme, path);
                Assert.fail((String)(string[0] + ":" + string[1] + "!/"));
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
        }
    }

    @Test
    public void testConstructorWithValidUri() {
        for (String string : new String[]{"foo:/b\u00c3\u00a4r/b\u00c3\u00a4z/", "foo:/b\u00c3\u00a4r/", "foo:/"}) {
            URI uri = URI.create(string);
            FsMountPoint mountPoint = FsMountPoint.create((URI)uri);
            Assert.assertThat((Object)mountPoint.toUri(), (Matcher)CoreMatchers.sameInstance((Object)uri));
            Assert.assertThat((Object)mountPoint.getPath(), (Matcher)CoreMatchers.nullValue());
            Assert.assertThat((Object)mountPoint.toString(), (Matcher)CoreMatchers.equalTo((Object)mountPoint.toUri().toString()));
            Assert.assertThat((Object)mountPoint, (Matcher)CoreMatchers.equalTo((Object)FsMountPoint.create((URI)mountPoint.toUri())));
            Assert.assertThat((Object)mountPoint.hashCode(), (Matcher)CoreMatchers.equalTo((Object)FsMountPoint.create((URI)mountPoint.toUri()).hashCode()));
        }
        for (String string : new String[][]{{"bar:baz:/ba%20ng!/", "bar", "baz:/ba%20ng"}, {"foo:bar:baz:/ba%20ng!/bo%20om?plo%20nk!/", "foo", "bar:baz:/ba%20ng!/bo%20om?plo%20nk"}, {"foo:bar:baz:/./b\u00e4ng!/./b\u00f6\u00f6m?pl\u00f6nk!/", "foo", "bar:baz:/b\u00e4ng!/b\u00f6\u00f6m?pl\u00f6nk"}, {"foo:bar:baz:/./bang!/boom?plonk!/", "foo", "bar:baz:/bang!/boom?plonk"}, {"foo:bar:baz:/bang!/./boom?plonk!/", "foo", "bar:baz:/bang!/boom?plonk"}, {"foo:bar:baz:/bang!/boom?plonk!/", "foo", "bar:baz:/bang!/boom?plonk"}, {"foo:bar:baz:/bang!/boom!/", "foo", "bar:baz:/bang!/boom"}, {"foo:bar:/baz?bang!/", "foo", "bar:/baz?bang"}, {"foo:bar:/baz!/", "foo", "bar:/baz"}}) {
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(string[0]), (FsUriModifier)FsUriModifier.CANONICALIZE);
            FsScheme scheme = FsScheme.create((String)string[1]);
            FsPath path = FsPath.create((URI)URI.create(string[2]));
            Assert.assertThat((Object)mountPoint.getScheme(), (Matcher)CoreMatchers.equalTo((Object)scheme));
            Assert.assertThat((Object)mountPoint.getPath(), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)mountPoint.toString(), (Matcher)CoreMatchers.equalTo((Object)mountPoint.toUri().toString()));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.toUri()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((URI)URI.create(mountPoint.toUri().getScheme() + ":" + mountPoint.getPath() + "!/")), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((FsScheme)mountPoint.getScheme(), (FsPath)mountPoint.getPath()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.toUri()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.toUri()).hashCode(), (Matcher)CoreMatchers.equalTo((Object)mountPoint.hashCode()));
            Assert.assertThat((Object)FsMountPoint.create((URI)mountPoint.resolve(FsEntryName.ROOT).toUri()), (Matcher)CoreMatchers.equalTo((Object)mountPoint));
        }
    }

    @Test
    public void testResolve() {
        for (String[] params : new String[][]{{"foo:bar:/baz?plonk!/", "", "baz", "foo:bar:/baz?plonk!/"}, {"foo:bar:/b\u00c3\u00a4z?b\u00c3\u00b6\u00c3\u00b6m!/", "b\u00c3\u00a4ng?pl\u00c3\u00b6nk", "b\u00c3\u00a4z/b\u00c3\u00a4ng?pl\u00c3\u00b6nk", "foo:bar:/b\u00c3\u00a4z?b\u00c3\u00b6\u00c3\u00b6m!/b\u00c3\u00a4ng?pl\u00c3\u00b6nk"}, {"foo:bar:/baz!/", "bang?boom", "baz/bang?boom", "foo:bar:/baz!/bang?boom"}, {"foo:bar:/baz!/", "bang", "baz/bang", "foo:bar:/baz!/bang"}, {"foo:bar:/baz!/", "", "baz", "foo:bar:/baz!/"}, {"foo:bar:/baz?plonk!/", "bang?boom", "baz/bang?boom", "foo:bar:/baz?plonk!/bang?boom"}, {"foo:bar:/baz?plonk!/", "bang", "baz/bang", "foo:bar:/baz?plonk!/bang"}, {"foo:/bar/", "baz?bang", null, "foo:/bar/baz?bang"}, {"foo:/bar/", "baz", null, "foo:/bar/baz"}, {"foo:/bar/", "", null, "foo:/bar/"}, {"foo:/bar/", "baz", null, "foo:/bar/baz"}}) {
            FsMountPoint mountPoint = FsMountPoint.create((URI)URI.create(params[0]));
            FsEntryName entryName = FsEntryName.create((URI)URI.create(params[1]));
            FsEntryName parentEntryName = null == params[2] ? null : FsEntryName.create((URI)URI.create(params[2]));
            FsPath path = FsPath.create((URI)URI.create(params[3]));
            if (null != parentEntryName) {
                Assert.assertThat((Object)mountPoint.getPath().resolve(entryName).getEntryName(), (Matcher)CoreMatchers.equalTo((Object)parentEntryName));
            }
            Assert.assertThat((Object)mountPoint.resolve(entryName), (Matcher)CoreMatchers.equalTo((Object)path));
            Assert.assertThat((Object)mountPoint.resolve(entryName).toUri().isAbsolute(), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    @Test
    public void testHierarchicalize() {
        for (String[] params : new String[][]{{"foo:bar:baz:/x/b\u00f6%20m?pl\u00f6%20k!/b\u00e4%20g?z\u00f6%20k!/", "baz:/x/b\u00f6%20m/b\u00e4%20g?z\u00f6%20k"}, {"foo:bar:baz:/x/b\u00f6\u00f6m?pl\u00f6nk!/b\u00e4ng?z\u00f6nk!/", "baz:/x/b\u00f6\u00f6m/b\u00e4ng?z\u00f6nk"}, {"foo:bar:baz:/boom?plonk!/bang?zonk!/", "baz:/boom/bang?zonk"}, {"foo:bar:baz:/boom!/bang!/", "baz:/boom/bang"}, {"foo:bar:/baz?boom!/", "bar:/baz?boom"}, {"foo:bar:/baz!/", "bar:/baz"}, {"foo:/bar/", "foo:/bar/"}}) {
            FsMountPoint mp = FsMountPoint.create((URI)URI.create(params[0]));
            URI hmp = mp.toHierarchicalUri();
            FsPath p = FsPath.create((URI)URI.create(params[0]));
            URI hp = p.toHierarchicalUri();
            Assert.assertThat((Object)hmp, (Matcher)CoreMatchers.equalTo((Object)URI.create(params[1])));
            Assert.assertThat((Object)hmp, (Matcher)CoreMatchers.equalTo((Object)hp));
        }
    }
}

