/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket.sl;

import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.spi.IOPoolService;
import de.schlichtherle.truezip.util.ServiceLocator;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class IOPoolLocator
implements IOPoolProvider {
    public static final IOPoolLocator SINGLETON = new IOPoolLocator();

    private IOPoolLocator() {
    }

    @Override
    public IOPool<?> get() {
        return Boot.SERVICE.get();
    }

    private static class Boot {
        static final IOPoolService SERVICE;

        Boot() {
        }

        static {
            Logger logger = Logger.getLogger(IOPoolLocator.class.getName(), IOPoolLocator.class.getName());
            ServiceLocator locator = new ServiceLocator(IOPoolLocator.class.getClassLoader());
            IOPoolService service = locator.getService(IOPoolService.class, null);
            if (null == service) {
                IOPoolService oldService = null;
                Iterator<IOPoolService> i = locator.getServices(IOPoolService.class);
                while (i.hasNext()) {
                    service = i.next();
                    logger.log(Level.CONFIG, "located", service);
                    if (null != oldService && oldService.getPriority() > service.getPriority()) {
                        service = oldService;
                    }
                    oldService = service;
                }
            }
            if (null == service) {
                throw new ServiceConfigurationError(MessageFormat.format(ResourceBundle.getBundle(IOPoolLocator.class.getName()).getString("none"), IOPoolService.class));
            }
            logger.log(Level.CONFIG, "provided", service);
            SERVICE = service;
        }
    }
}

