/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.Paths;
import java.io.File;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public class PathsTest {
    @Test
    public void testCutTrailingSeparators() {
        String path = "";
        Assert.assertSame((Object)path, (Object)Paths.cutTrailingSeparators((String)path, (char)'/'));
        path = "d";
        Assert.assertSame((Object)path, (Object)Paths.cutTrailingSeparators((String)path, (char)'/'));
        Assert.assertEquals((Object)"d", (Object)Paths.cutTrailingSeparators((String)"d/", (char)'/'));
        Assert.assertEquals((Object)"d", (Object)Paths.cutTrailingSeparators((String)"d//", (char)'/'));
        Assert.assertEquals((Object)"d", (Object)Paths.cutTrailingSeparators((String)"d///", (char)'/'));
        path = "/d";
        Assert.assertSame((Object)path, (Object)Paths.cutTrailingSeparators((String)path, (char)'/'));
        Assert.assertEquals((Object)"/d", (Object)Paths.cutTrailingSeparators((String)"/d/", (char)'/'));
        Assert.assertEquals((Object)"/d", (Object)Paths.cutTrailingSeparators((String)"/d//", (char)'/'));
        Assert.assertEquals((Object)"/d", (Object)Paths.cutTrailingSeparators((String)"/d///", (char)'/'));
        path = new String("/");
        Assert.assertSame((Object)path, (Object)Paths.cutTrailingSeparators((String)path, (char)'/'));
        Assert.assertEquals((Object)"/", (Object)Paths.cutTrailingSeparators((String)"//", (char)'/'));
        Assert.assertEquals((Object)"/", (Object)Paths.cutTrailingSeparators((String)"///", (char)'/'));
        Assert.assertEquals((Object)"/", (Object)Paths.cutTrailingSeparators((String)"////", (char)'/'));
    }

    @Test
    public void testSplitPathName() {
        String fs = File.separator;
        this.assertSplit(fs + "d" + fs + "f" + fs);
        this.assertSplit(fs + "d" + fs + "f");
        this.assertSplit(fs + "d" + fs);
        this.assertSplit(fs + "d");
        this.assertSplit(fs);
        this.assertSplit("d" + fs + "f" + fs);
        this.assertSplit("d" + fs + "f");
        this.assertSplit("d" + fs);
        this.assertSplit("d");
        this.assertSplit("d");
        this.assertSplit("");
        this.assertSplit(".");
        this.assertSplit("..");
        this.assertSplit("d");
        this.assertSplit("d" + fs);
        this.assertSplit("d" + fs + fs);
        this.assertSplit("d" + fs + fs + fs);
        this.assertSplit("d" + fs + "f");
        this.assertSplit("d" + fs + "f" + fs);
        this.assertSplit("d" + fs + "f" + fs + fs);
        this.assertSplit("d" + fs + "f" + fs + fs + fs);
        this.assertSplit("d" + fs + fs + "f");
        this.assertSplit("d" + fs + fs + fs + "f");
        this.assertSplit("d" + fs + fs + fs + "f" + fs);
        this.assertSplit("d" + fs + fs + fs + "f" + fs + fs);
        this.assertSplit("d" + fs + fs + fs + "f" + fs + fs + fs);
        if (File.separatorChar == '\\') {
            this.assertSplit("\\\\\\h");
            this.assertSplit("\\\\\\\\h");
            this.assertSplit("\\\\\\\\\\h");
            this.assertSplit("\\\\h\\share\\\\f\\\\");
            this.assertSplit("\\\\h\\share\\f\\");
            this.assertSplit("\\\\h\\share\\f");
            this.assertSplit("\\\\h\\share\\");
            this.assertSplit("\\\\h\\share");
            this.assertSplit("\\\\h\\");
            this.assertSplit("\\\\h");
            this.assertSplit("\\\\h");
            this.assertSplit("\\\\");
            this.assertSplit("\\\\\\");
            this.assertSplit("C:\\d\\\\f\\\\");
            this.assertSplit("C:\\d\\f\\");
            this.assertSplit("C:\\d\\f");
            this.assertSplit("C:\\d\\");
            this.assertSplit("C:\\d");
            this.assertSplit("C:\\d");
            this.assertSplit("C:\\");
            this.assertSplit("C:\\\\");
            this.assertSplit("C:d\\\\f\\\\");
            this.assertSplit("C:d\\f\\");
            this.assertSplit("C:d\\f");
            this.assertSplit("C:d\\");
            this.assertSplit("C:d");
            this.assertSplit("C:d");
            this.assertSplit("C:");
        }
    }

    private void assertSplit(String path) {
        File file = new File(path);
        String parent = file.getParent();
        String member = file.getName();
        Paths.Splitter splitter = Paths.split((String)path, (char)File.separatorChar, (boolean)false);
        Assert.assertEquals((Object)parent, (Object)splitter.getParentPath());
        Assert.assertEquals((Object)member, (Object)splitter.getMemberName());
    }

    @Test
    public void testNormalize() {
        this.assertNormalize("", "");
        this.assertNormalize("a/b/c/d", "a/b/c/d");
        this.assertNormalize("a", "./a");
        this.assertNormalize("", ".");
        this.assertNormalize("..", "./..");
        this.assertNormalize("../..", "./../..");
        this.assertNormalize("../../..", "./../../..");
        this.assertNormalize("../../..", "./.././.././..");
        this.assertNormalize("../../..", "././../././../././..");
        this.assertNormalize("../../..", "./././.././././.././././..");
        this.assertNormalize("..", "..");
        this.assertNormalize("../..", "../..");
        this.assertNormalize("../../..", "../../..");
        this.assertNormalize("../../../..", "../../../..");
        this.assertNormalize("../../../..", "../.././.././..");
        this.assertNormalize("../../../..", ".././../././../././..");
        this.assertNormalize("../../../..", "../././.././././.././././..");
        this.assertNormalize("a", "a");
        this.assertNormalize("", "a/..");
        this.assertNormalize("..", "a/../..");
        this.assertNormalize("../..", "a/../../..");
        this.assertNormalize("../..", "a/./.././.././..");
        this.assertNormalize("../..", "a/././../././../././..");
        this.assertNormalize("../..", "a/./././.././././.././././..");
        this.assertNormalize("a/b", "a/b");
        this.assertNormalize("a/", "a/b/..");
        this.assertNormalize("", "a/b/../..");
        this.assertNormalize("..", "a/b/../../..");
        this.assertNormalize("..", "a/b/./.././.././..");
        this.assertNormalize("..", "a/b/././../././../././..");
        this.assertNormalize("..", "a/b/./././.././././.././././..");
        this.assertNormalize("a/b/c", "a/b/c");
        this.assertNormalize("a/b/", "a/b/c/..");
        this.assertNormalize("a/", "a/b/c/../..");
        this.assertNormalize("", "a/b/c/../../..");
        this.assertNormalize("", "a/b/c/./.././.././..");
        this.assertNormalize("", "a/b/c/././../././../././..");
        this.assertNormalize("", "a/b/c/./././.././././.././././..");
        this.assertNormalize("a/b/c/d", "a/b/c/d");
        this.assertNormalize("a/b/c/", "a/b/c/d/..");
        this.assertNormalize("a/b/", "a/b/c/d/../..");
        this.assertNormalize("a/", "a/b/c/d/../../..");
        this.assertNormalize("a/", "a/b/c/d/./.././.././..");
        this.assertNormalize("a/", "a/b/c/d/././../././../././..");
        this.assertNormalize("a/", "a/b/c/d/./././.././././.././././..");
        this.assertNormalize("a/b/c/d", "a//b//c//d");
        this.assertNormalize("a/b/c/d", "a///b///c///d");
        this.assertNormalize("a/b/c/d", "a////b////c////d");
        this.assertNormalize("a/b/c/", "a////b////c////d////..");
        this.assertNormalize("a/b/", "a////b////c////d////..////..");
        this.assertNormalize("a/b/", "a//.//b/.///c///./d//.//.././//..");
        this.assertNormalize("a/b/", "a/////b/////c/////d/////../////..");
        this.assertNormalize("a", "x/../a");
        this.assertNormalize("a/b", "x/../a/y/../b");
        this.assertNormalize("a/b/c", "x/../a/y/../b/z/../c");
        this.assertNormalize("../a", "x/../../a");
        this.assertNormalize("../a/b", "x/../../a/y/../b");
        this.assertNormalize("../a/b/c", "x/../../a/y/../b/z/../c");
        this.assertNormalize("../a", "x/.././../a");
        this.assertNormalize("../a/b", "x/.././../a/y/../b");
        this.assertNormalize("../a/b/c", "x/.././../a/y/../b/z/../c");
        this.assertNormalize("../a", "x/..//../a");
        this.assertNormalize("../a/b", "x/..//../a/y/../b");
        this.assertNormalize("../a/b/c", "x/..//../a/y/../b/z/../c");
        this.assertNormalize("../../a", "x/../../../a");
        this.assertNormalize("../../a/b", "x/../../../a/y/../b");
        this.assertNormalize("../../a/b/c", "x/../../../a/y/../b/z/../c");
        this.assertNormalize("../../a", "x/.././.././../a");
        this.assertNormalize("../../a/b", "x/.././.././../a/y/../b");
        this.assertNormalize("../../a/b/c", "x/.././.././../a/y/../b/z/../c");
        this.assertNormalize("../../a", "x/..//..//../a");
        this.assertNormalize("../../a/b", "x/..//..//../a/y/../b");
        this.assertNormalize("../../a/b/c", "x/..//..//../a/y/../b/z/../c");
        this.assertNormalize("a", "x/x/../../a");
        this.assertNormalize("a/b", "x/x/../../a/y/y/../../b");
        this.assertNormalize("a/b/c", "x/x/../../a/y/y/../../b/z/z/../../c");
        this.assertNormalize("/", "/");
        this.assertNormalize("/", "/.");
        this.assertNormalize("/", "/./");
        this.assertNormalize("/..", "/..");
        this.assertNormalize("/../", "/../.");
        this.assertNormalize("/../..", "/.././..");
        this.assertNormalize("/../../", "/.././../.");
        this.assertNormalize("", ".");
        this.assertNormalize("", "./");
        this.assertNormalize("..", "..");
        this.assertNormalize("../", "../");
        this.assertNormalize("a", "./a");
        this.assertNormalize("a/", "./a/");
        this.assertNormalize("../a", "../a");
        this.assertNormalize("../a/", "../a/");
        this.assertNormalize("a/b", "./a/./b");
        this.assertNormalize("a/b/", "./a/./b/");
        this.assertNormalize("../a/b", "../a/./b");
        this.assertNormalize("../a/b/", "../a/./b/");
        this.assertNormalize("b", "./a/../b");
        this.assertNormalize("b/", "./a/../b/");
        this.assertNormalize("../b", "../a/../b");
        this.assertNormalize("../b/", "../a/../b/");
        this.assertNormalize("", ".//");
        this.assertNormalize("", ".///");
        this.assertNormalize("", ".////");
        this.assertNormalize("../", "..//");
        this.assertNormalize("a/", ".//a//");
        this.assertNormalize("../a", "..//a");
        this.assertNormalize("../a/", "..//a//");
        this.assertNormalize("a/b", ".//a//.//b");
        this.assertNormalize("a/b/", ".//a//.//b//");
        this.assertNormalize("../a/b", "..//a//.//b");
        this.assertNormalize("../a/b/", "..//a//.//b//");
        this.assertNormalize("b/", ".//a//..//b//");
        this.assertNormalize("../b", "..//a//..//b");
        this.assertNormalize("../b/", "..//a//..//b//");
    }

    private void assertNormalize(String expected, String path) {
        this.assertNormalize(expected, path, '/');
    }

    private void assertNormalize(String expected, String path, char separatorChar) {
        Assert.assertEquals((Object)URI.create(path.replace(separatorChar, '/')).normalize().toString().replace('/', separatorChar), (Object)expected);
        String result = Paths.normalize((String)path, (char)separatorChar);
        Assert.assertEquals((Object)expected, (Object)result);
        Assert.assertTrue((!result.equals(path) || result == path ? 1 : 0) != 0);
    }
}

