/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsDecoratingEntry;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOCache;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import de.schlichtherle.truezip.util.JSE7;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class FsCachingController
extends FsDecoratingController<FsConcurrentModel, FsController<? extends FsConcurrentModel>> {
    private static final IOCache.Strategy STRATEGY = IOCache.Strategy.WRITE_BACK;
    private final IOPool<?> pool;
    private final Map<FsEntryName, EntryCache> caches = new HashMap<FsEntryName, EntryCache>();
    private static final ProxyOutputSocketFactory factory = JSE7.AVAILABLE ? ProxyOutputSocketFactory.NIO : ProxyOutputSocketFactory.OIO;

    public FsCachingController(FsController<? extends FsConcurrentModel> controller, IOPool<?> pool) {
        super(controller);
        if (null == pool) {
            throw new NullPointerException();
        }
        this.pool = pool;
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new Output(name, options, template);
    }

    @Override
    public void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, Entry template) throws IOException {
        assert (((FsConcurrentModel)this.getModel()).isWriteLockedByCurrentThread());
        EntryCache cache = this.caches.get(name);
        if (null != cache) {
            this.delegate.mknod(name, type, options, template);
            this.caches.remove(name);
            cache.clear();
        } else {
            this.delegate.mknod(name, type, options, template);
        }
    }

    @Override
    public void unlink(FsEntryName name) throws IOException {
        assert (((FsConcurrentModel)this.getModel()).isWriteLockedByCurrentThread());
        EntryCache cache = this.caches.get(name);
        if (null != cache) {
            this.delegate.unlink(name);
            this.caches.remove(name);
            cache.clear();
        } else {
            this.delegate.unlink(name);
        }
    }

    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.beforeSync(options, handler);
        this.delegate.sync(options.clear(FsSyncOption.CLEAR_CACHE), handler);
    }

    private <X extends IOException> void beforeSync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (((FsConcurrentModel)this.getModel()).isWriteLockedByCurrentThread());
        if (0 >= this.caches.size()) {
            return;
        }
        boolean flush = !options.get(FsSyncOption.ABORT_CHANGES);
        boolean clear = !flush || options.get(FsSyncOption.CLEAR_CACHE);
        Iterator<EntryCache> i = this.caches.values().iterator();
        while (i.hasNext()) {
            EntryCache cache = i.next();
            try {
                if (!flush) continue;
                cache.flush();
            }
            catch (IOException ex) {
                throw (IOException)handler.fail(new FsSyncException((FsModel)this.getModel(), ex));
            }
            finally {
                try {
                    if (!clear) continue;
                    i.remove();
                    cache.clear();
                }
                catch (IOException ex) {
                    handler.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
                }
            }
        }
    }

    private static final class CacheEntry
    extends FsDecoratingEntry<Entry> {
        CacheEntry(Entry entry) {
            super(entry);
        }

        @Override
        public Set<String> getMembers() {
            return null;
        }

        @Override
        public Set<Entry.Type> getTypes() {
            return FILE_TYPE_SET;
        }
    }

    private class EntryCache {
        private final FsEntryName name;
        private final IOCache cache;
        @CheckForNull
        private volatile InputSocket<?> input;
        @CheckForNull
        private volatile OutputSocket<?> output;
        @Nullable
        private volatile BitField<FsOutputOption> outputOptions;
        @CheckForNull
        private volatile Entry template;

        EntryCache(FsEntryName name) {
            this.name = name;
            this.cache = STRATEGY.newCache(FsCachingController.this.pool);
        }

        EntryCache configure(BitField<FsInputOption> options) {
            this.cache.configure(new ProxyInputSocket(FsCachingController.this.delegate.getInputSocket(this.name, options.clear(FsInputOption.CACHE))));
            this.input = null;
            return this;
        }

        EntryCache configure(BitField<FsOutputOption> options, @CheckForNull Entry template) {
            this.outputOptions = options.clear(FsOutputOption.CACHE);
            this.template = template;
            this.cache.configure(FsCachingController.this.delegate.getOutputSocket(this.name, this.outputOptions, this.template));
            this.output = null;
            return this;
        }

        void flush() throws IOException {
            this.cache.flush();
        }

        void clear() throws IOException {
            this.cache.clear();
        }

        @CheckForNull
        FsEntry getEntry() {
            CacheEntry cacheEntry;
            Entry entry = this.cache.getEntry();
            if (null == entry) {
                cacheEntry = null;
            } else {
                Entry template = this.template;
                Entry entry2 = null == template ? entry : template;
                cacheEntry = new CacheEntry(entry2);
            }
            return cacheEntry;
        }

        InputSocket<?> getInputSocket() {
            InputSocket<?> input = this.input;
            return null != input ? input : (this.input = this.cache.getInputSocket());
        }

        OutputSocket<?> getOutputSocket() {
            OutputSocket<?> output = this.output;
            return null != output ? output : (this.output = factory.newOutputSocket(this, this.cache.getOutputSocket()));
        }

        private final class ProxyOutputStream
        extends DecoratingOutputStream {
            ProxyOutputStream(OutputStream out) {
                super(out);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    this.delegate.flush();
                }
                finally {
                    try {
                        if (null == EntryCache.this.template) {
                            FsCachingController.this.delegate.mknod(EntryCache.this.name, Entry.Type.FILE, EntryCache.this.outputOptions, EntryCache.this.cache.getEntry());
                        }
                    }
                    finally {
                        this.delegate.close();
                    }
                }
            }
        }

        private class ProxyOutputSocket
        extends DecoratingOutputSocket<Entry> {
            ProxyOutputSocket(OutputSocket<?> output) {
                super(output);
            }

            @Override
            public final OutputStream newOutputStream() throws IOException {
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).isWriteLockedByCurrentThread());
                FsCachingController.this.delegate.mknod(EntryCache.this.name, Entry.Type.FILE, EntryCache.this.outputOptions, EntryCache.this.template);
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).isTouched());
                OutputStream out = this.getBoundSocket().newOutputStream();
                FsCachingController.this.caches.put(EntryCache.this.name, EntryCache.this);
                return new ProxyOutputStream(out);
            }
        }

        private final class ProxySeekableByteChannel
        extends DecoratingSeekableByteChannel {
            ProxySeekableByteChannel(SeekableByteChannel sbc) {
                super(sbc);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    if (null == EntryCache.this.template) {
                        FsCachingController.this.delegate.mknod(EntryCache.this.name, Entry.Type.FILE, EntryCache.this.outputOptions, EntryCache.this.cache.getEntry());
                    }
                }
                finally {
                    this.delegate.close();
                }
            }
        }

        private final class Nio2ProxyOutputSocket
        extends ProxyOutputSocket {
            Nio2ProxyOutputSocket(OutputSocket<?> output) {
                super(output);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).isWriteLockedByCurrentThread());
                FsCachingController.this.delegate.mknod(EntryCache.this.name, Entry.Type.FILE, EntryCache.this.outputOptions, EntryCache.this.template);
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).isTouched());
                SeekableByteChannel sbc = this.getBoundSocket().newSeekableByteChannel();
                FsCachingController.this.caches.put(EntryCache.this.name, EntryCache.this);
                return new ProxySeekableByteChannel(sbc);
            }
        }

        private final class ProxyInputSocket
        extends DecoratingInputSocket<Entry> {
            ProxyInputSocket(InputSocket<?> input) {
                super(input);
            }

            @Override
            public SeekableByteChannel newSeekableByteChannel() throws IOException {
                throw new AssertionError();
            }

            @Override
            public ReadOnlyFile newReadOnlyFile() throws IOException {
                throw new AssertionError();
            }

            @Override
            public InputStream newInputStream() throws IOException {
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).isWriteLockedByCurrentThread());
                InputStream in = this.getBoundSocket().newInputStream();
                assert (((FsConcurrentModel)FsCachingController.this.getModel()).isTouched());
                FsCachingController.this.caches.put(EntryCache.this.name, EntryCache.this);
                return in;
            }
        }
    }

    private static enum ProxyOutputSocketFactory {
        OIO{

            @Override
            OutputSocket<?> newOutputSocket(EntryCache cache, OutputSocket<?> output) {
                EntryCache entryCache = cache;
                entryCache.getClass();
                return entryCache.new EntryCache.ProxyOutputSocket(output);
            }
        }
        ,
        NIO{

            @Override
            OutputSocket<?> newOutputSocket(EntryCache cache, OutputSocket<?> output) {
                EntryCache entryCache = cache;
                entryCache.getClass();
                return entryCache.new EntryCache.Nio2ProxyOutputSocket(output);
            }
        };


        abstract OutputSocket<?> newOutputSocket(EntryCache var1, OutputSocket<?> var2);
    }

    private final class Output
    extends DecoratingOutputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsOutputOption> options;
        @CheckForNull
        final Entry template;

        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            super(FsCachingController.this.delegate.getOutputSocket(name, options, template));
            this.name = name;
            this.options = options;
            this.template = template;
        }

        @Override
        public OutputSocket<?> getBoundSocket() throws IOException {
            EntryCache cache = (EntryCache)FsCachingController.this.caches.get(this.name);
            if (null == cache) {
                if (!this.options.get(FsOutputOption.CACHE)) {
                    return super.getBoundSocket();
                }
                ((FsConcurrentModel)FsCachingController.this.getModel()).assertWriteLockedByCurrentThread();
                cache = new EntryCache(this.name);
            } else if (this.options.get(FsOutputOption.APPEND)) {
                assert (IOCache.Strategy.WRITE_THROUGH == STRATEGY);
                cache.flush();
            }
            return cache.configure(this.options, this.template).getOutputSocket().bind(this);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            return (Entry)this.getBoundSocket().getLocalTarget();
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return this.getBoundSocket().newSeekableByteChannel();
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return this.getBoundSocket().newOutputStream();
        }
    }

    private final class Input
    extends DecoratingInputSocket<Entry> {
        final FsEntryName name;
        final BitField<FsInputOption> options;

        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsCachingController.this.delegate.getInputSocket(name, options));
            this.name = name;
            this.options = options;
        }

        @Override
        public InputSocket<?> getBoundSocket() throws IOException {
            EntryCache cache = (EntryCache)FsCachingController.this.caches.get(this.name);
            if (null == cache) {
                if (!this.options.get(FsInputOption.CACHE)) {
                    return super.getBoundSocket();
                }
                ((FsConcurrentModel)FsCachingController.this.getModel()).assertWriteLockedByCurrentThread();
                cache = new EntryCache(this.name);
            }
            return cache.configure(this.options).getInputSocket().bind(this);
        }

        @Override
        public Entry getLocalTarget() throws IOException {
            return (Entry)this.getBoundSocket().getLocalTarget();
        }

        @Override
        public Entry getPeerTarget() throws IOException {
            return this.getBoundSocket().getPeerTarget();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return this.getBoundSocket().newSeekableByteChannel();
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return this.getBoundSocket().newReadOnlyFile();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.getBoundSocket().newInputStream();
        }
    }
}

