/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.EntryName;
import de.schlichtherle.truezip.fs.FsUriModifier;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public final class FsEntryName
extends EntryName {
    private static final long serialVersionUID = 2212342253466752478L;
    private static final String ILLEGAL_PREFIX = "../";
    public static final FsEntryName ROOT;

    @Deprecated
    public static FsEntryName create(String uri) {
        return FsEntryName.create(uri, FsUriModifier.NULL);
    }

    @Deprecated
    public static FsEntryName create(String uri, FsUriModifier modifier) {
        try {
            return uri.isEmpty() ? ROOT : new FsEntryName(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static FsEntryName create(URI uri) {
        return FsEntryName.create(uri, FsUriModifier.NULL);
    }

    public static FsEntryName create(URI uri, FsUriModifier modifier) {
        try {
            return uri.toString().isEmpty() ? ROOT : new FsEntryName(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Deprecated
    public FsEntryName(String uri) throws URISyntaxException {
        this(uri, FsUriModifier.NULL);
    }

    @Deprecated
    public FsEntryName(String uri, FsUriModifier modifier) throws URISyntaxException {
        this(new URI(uri), modifier);
    }

    public FsEntryName(URI uri) throws URISyntaxException {
        this(uri, FsUriModifier.NULL);
    }

    public FsEntryName(URI uri, FsUriModifier modifier) throws URISyntaxException {
        uri = modifier.modify(uri, FsUriModifier.PostFix.ENTRY_NAME);
        super(uri);
        this.parse(uri);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.parse(this.toUri());
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(URI uri) throws URISyntaxException {
        String p = uri.getRawPath();
        if (p.startsWith("/")) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Illegal start of URI path component");
        }
        if (!p.isEmpty() && ILLEGAL_PREFIX.startsWith(p.substring(0, Math.min(p.length(), ILLEGAL_PREFIX.length())))) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Illegal start of URI path component");
        }
        if (p.endsWith("/")) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Illegal separator \"/\" at end of URI path");
        }
        if (null != uri.getRawFragment()) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Fragment component not allowed");
        }
        assert (this.invariants());
    }

    private static String quote(Object s) {
        return "\"" + s + "\"";
    }

    public FsEntryName(FsEntryName parent, FsEntryName member) {
        super(parent, member);
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.toUri());
        assert (null == this.toUri().getRawFragment());
        assert (this.toUri().normalize() == this.toUri());
        String p = this.toUri().getRawPath();
        assert (!"..".equals(p));
        assert (!p.startsWith("/"));
        assert (!p.startsWith("./"));
        assert (!p.startsWith(ILLEGAL_PREFIX));
        assert (!p.endsWith("/"));
        return true;
    }

    public boolean isRoot() {
        URI uri = this.toUri();
        String path = uri.getRawPath();
        if (null != path && !path.isEmpty()) {
            return false;
        }
        String query = uri.getRawQuery();
        return null == query;
    }

    static {
        try {
            ROOT = new FsEntryName(new URI(""));
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

