/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.spi;

import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.util.ServiceLocator;
import de.schlichtherle.truezip.util.SuffixSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.TreeSet;

@DefaultAnnotation(value={NonNull.class})
public abstract class FsDriverService
implements FsDriverProvider {
    public String toString() {
        return this.getClass().getName();
    }

    public static Map<FsScheme, FsDriver> newMap(Object[][] config) {
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>();
        for (Object[] param : config) {
            Collection<FsScheme> schemes = FsDriverService.toSchemes(param[0]);
            FsDriver newDriver = FsDriverService.toDriver(param[1]);
            if (schemes.isEmpty()) {
                throw new IllegalArgumentException("No schemes for " + newDriver);
            }
            for (FsScheme scheme : schemes) {
                FsDriver oldDriver = drivers.put(scheme, newDriver);
                if (null == oldDriver || oldDriver.getPriority() <= newDriver.getPriority()) continue;
                drivers.put(scheme, oldDriver);
            }
        }
        return Collections.unmodifiableMap(drivers);
    }

    @NonNull
    private static Collection<FsScheme> toSchemes(@NonNull Object o) {
        TreeSet<FsScheme> set = new TreeSet<FsScheme>();
        try {
            if (o instanceof Collection) {
                for (Object p : (Collection)o) {
                    if (p instanceof FsScheme) {
                        set.add((FsScheme)p);
                        continue;
                    }
                    for (String q : new SuffixSet(p.toString())) {
                        set.add(new FsScheme(q));
                    }
                }
            } else if (o instanceof FsScheme) {
                set.add((FsScheme)o);
            } else {
                for (String p : new SuffixSet(o.toString())) {
                    set.add(new FsScheme(p));
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
        return set;
    }

    @CheckForNull
    private static FsDriver toDriver(@CheckForNull Object driver) {
        try {
            if (driver instanceof String) {
                driver = new ServiceLocator(FsDriverService.class.getClassLoader()).getClass((String)((Object)driver));
            }
        }
        catch (ServiceConfigurationError ex) {
            throw new IllegalArgumentException(ex);
        }
        try {
            if (driver instanceof Class) {
                driver = ((Class)driver).newInstance();
            }
            return (FsDriver)((Object)driver);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

