/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsNotWriteLockedException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FsConcurrentController
extends FsDecoratingController<FsConcurrentModel, FsController<? extends FsConcurrentModel>> {
    private volatile ReentrantReadWriteLock.ReadLock readLock;
    private volatile ReentrantReadWriteLock.WriteLock writeLock;

    public FsConcurrentController(@NonNull FsController<? extends FsConcurrentModel> controller) {
        super(controller);
    }

    private ReentrantReadWriteLock.ReadLock readLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock;
        return null != readLock ? readLock : (this.readLock = ((FsConcurrentModel)this.getModel()).readLock());
    }

    private ReentrantReadWriteLock.WriteLock writeLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock;
        return null != writeLock ? writeLock : (this.writeLock = ((FsConcurrentModel)this.getModel()).writeLock());
    }

    private void assertNotReadLockedByCurrentThread(FsNotWriteLockedException ex) throws FsNotWriteLockedException {
        ((FsConcurrentModel)this.getModel()).assertNotReadLockedByCurrentThread(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getOpenIcon() throws IOException {
        this.readLock().lock();
        try {
            Icon icon = this.delegate.getOpenIcon();
            this.readLock().unlock();
            return icon;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    Icon icon = this.delegate.getOpenIcon();
                    return icon;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Icon getClosedIcon() throws IOException {
        this.readLock().lock();
        try {
            Icon icon = this.delegate.getClosedIcon();
            this.readLock().unlock();
            return icon;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    Icon icon = this.delegate.getClosedIcon();
                    return icon;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws IOException {
        this.readLock().lock();
        try {
            boolean bl = this.delegate.isReadOnly();
            this.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    boolean bl = this.delegate.isReadOnly();
                    return bl;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FsEntry getEntry(FsEntryName name) throws IOException {
        this.readLock().lock();
        try {
            FsEntry fsEntry = this.delegate.getEntry(name);
            this.readLock().unlock();
            return fsEntry;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    FsEntry fsEntry = this.delegate.getEntry(name);
                    return fsEntry;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadable(FsEntryName name) throws IOException {
        this.readLock().lock();
        try {
            boolean bl = this.delegate.isReadable(name);
            this.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    boolean bl = this.delegate.isReadable(name);
                    return bl;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWritable(FsEntryName name) throws IOException {
        this.readLock().lock();
        try {
            boolean bl = this.delegate.isWritable(name);
            this.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.readLock().unlock();
                throw throwable;
            }
            catch (FsNotWriteLockedException ex) {
                this.assertNotReadLockedByCurrentThread(ex);
                this.writeLock().lock();
                try {
                    boolean bl = this.delegate.isWritable(name);
                    return bl;
                }
                finally {
                    this.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(FsEntryName name) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            this.delegate.setReadOnly(name);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            boolean bl = this.delegate.setTime(name, types, value);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTime(FsEntryName name, Map<Entry.Access, Long> times) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            boolean bl = this.delegate.setTime(name, times);
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(this.delegate.getInputSocket(name, options));
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new Output(this.delegate.getOutputSocket(name, options, template));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mknod(@NonNull FsEntryName name, @NonNull Entry.Type type, @NonNull BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            this.delegate.mknod(name, type, options, template);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlink(FsEntryName name) throws IOException {
        this.assertNotReadLockedByCurrentThread(null);
        this.writeLock().lock();
        try {
            this.delegate.unlink(name);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(@NonNull BitField<FsSyncOption> options, @NonNull ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.writeLock().lock();
        try {
            this.delegate.sync(options, handler);
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private final class Output
    extends DecoratingOutputSocket<Entry> {
        Output(OutputSocket<?> output) {
            super(output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Entry getLocalTarget() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                return entry;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                SeekableByteChannel seekableByteChannel = this.getBoundSocket().newSeekableByteChannel();
                return seekableByteChannel;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() throws IOException {
            FsConcurrentController.this.assertNotReadLockedByCurrentThread(null);
            FsConcurrentController.this.writeLock().lock();
            try {
                OutputStream outputStream = this.getBoundSocket().newOutputStream();
                return outputStream;
            }
            finally {
                FsConcurrentController.this.writeLock().unlock();
            }
        }
    }

    private final class Input
    extends DecoratingInputSocket<Entry> {
        Input(InputSocket<?> input) {
            super(input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Entry getLocalTarget() throws IOException {
            FsConcurrentController.this.readLock().lock();
            try {
                Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                FsConcurrentController.this.readLock().unlock();
                return entry;
            }
            catch (Throwable throwable) {
                try {
                    FsConcurrentController.this.readLock().unlock();
                    throw throwable;
                }
                catch (FsNotWriteLockedException ex) {
                    FsConcurrentController.this.assertNotReadLockedByCurrentThread(ex);
                    FsConcurrentController.this.writeLock().lock();
                    try {
                        Entry entry = (Entry)this.getBoundSocket().getLocalTarget();
                        return entry;
                    }
                    finally {
                        FsConcurrentController.this.writeLock().unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            FsConcurrentController.this.readLock().lock();
            try {
                SeekableByteChannel seekableByteChannel = this.getBoundSocket().newSeekableByteChannel();
                FsConcurrentController.this.readLock().unlock();
                return seekableByteChannel;
            }
            catch (Throwable throwable) {
                try {
                    FsConcurrentController.this.readLock().unlock();
                    throw throwable;
                }
                catch (FsNotWriteLockedException ex) {
                    FsConcurrentController.this.assertNotReadLockedByCurrentThread(ex);
                    FsConcurrentController.this.writeLock().lock();
                    try {
                        SeekableByteChannel seekableByteChannel = this.getBoundSocket().newSeekableByteChannel();
                        return seekableByteChannel;
                    }
                    finally {
                        FsConcurrentController.this.writeLock().unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            FsConcurrentController.this.readLock().lock();
            try {
                ReadOnlyFile readOnlyFile = this.getBoundSocket().newReadOnlyFile();
                FsConcurrentController.this.readLock().unlock();
                return readOnlyFile;
            }
            catch (Throwable throwable) {
                try {
                    FsConcurrentController.this.readLock().unlock();
                    throw throwable;
                }
                catch (FsNotWriteLockedException ex) {
                    FsConcurrentController.this.assertNotReadLockedByCurrentThread(ex);
                    FsConcurrentController.this.writeLock().lock();
                    try {
                        ReadOnlyFile readOnlyFile = this.getBoundSocket().newReadOnlyFile();
                        return readOnlyFile;
                    }
                    finally {
                        FsConcurrentController.this.writeLock().unlock();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream newInputStream() throws IOException {
            FsConcurrentController.this.readLock().lock();
            try {
                InputStream inputStream = this.getBoundSocket().newInputStream();
                FsConcurrentController.this.readLock().unlock();
                return inputStream;
            }
            catch (Throwable throwable) {
                try {
                    FsConcurrentController.this.readLock().unlock();
                    throw throwable;
                }
                catch (FsNotWriteLockedException ex) {
                    FsConcurrentController.this.assertNotReadLockedByCurrentThread(ex);
                    FsConcurrentController.this.writeLock().lock();
                    try {
                        InputStream inputStream = this.getBoundSocket().newInputStream();
                        return inputStream;
                    }
                    finally {
                        FsConcurrentController.this.writeLock().unlock();
                    }
                }
            }
        }
    }
}

