/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.DecoratingEntry;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import de.schlichtherle.truezip.fs.FsException;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class FsArchiveController<E extends FsArchiveEntry>
extends FsController<FsConcurrentModel> {
    private static final Logger logger = Logger.getLogger(FsArchiveController.class.getName(), FsArchiveController.class.getName());
    private static final BitField<FsOutputOption> AUTO_MOUNT_OPTIONS = BitField.noneOf(FsOutputOption.class);
    private static final BitField<FsSyncOption> UNLINK_SYNC_OPTIONS = BitField.of(FsSyncOption.ABORT_CHANGES);
    private final FsConcurrentModel model;

    protected FsArchiveController(FsConcurrentModel model) {
        if (null == model.getParent()) {
            throw new IllegalArgumentException();
        }
        this.model = model;
    }

    @Override
    public final FsConcurrentModel getModel() {
        return this.model;
    }

    final FsArchiveFileSystem<E> autoMount() throws IOException {
        return this.autoMount(false, AUTO_MOUNT_OPTIONS);
    }

    abstract FsArchiveFileSystem<E> autoMount(boolean var1, BitField<FsOutputOption> var2) throws IOException;

    @Override
    public final boolean isReadOnly() throws IOException {
        return this.autoMount().isReadOnly();
    }

    @Override
    public final FsEntry getEntry(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name);
    }

    @Override
    public final boolean isReadable(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name) != null;
    }

    @Override
    public final boolean isWritable(FsEntryName name) throws IOException {
        return this.autoMount().isWritable(name);
    }

    @Override
    public final void setReadOnly(FsEntryName name) throws IOException {
        this.autoMount().setReadOnly(name);
    }

    @Override
    public final boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value) throws IOException {
        this.autoSync(name, null);
        return this.autoMount().setTime(name, types, value);
    }

    @Override
    public final boolean setTime(FsEntryName name, Map<Entry.Access, Long> times) throws IOException {
        this.autoSync(name, null);
        return this.autoMount().setTime(name, times);
    }

    @Override
    public final InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(name);
    }

    abstract InputSocket<?> getInputSocket(String var1) throws IOException;

    @Override
    public final OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        return new Output(name, options, template);
    }

    abstract OutputSocket<?> getOutputSocket(E var1) throws IOException;

    @Override
    public final void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, @CheckForNull Entry template) throws IOException {
        if (name.isRoot()) {
            try {
                this.autoMount();
            }
            catch (FsFalsePositiveException ex) {
                if (Entry.Type.DIRECTORY != type) {
                    throw ex;
                }
                this.autoMount(true, options);
                return;
            }
            throw new FsEntryNotFoundException((FsModel)this.getModel(), name, "directory exists already");
        }
        this.autoMount(options.get(FsOutputOption.CREATE_PARENTS), options).mknod(name, type, options, template).run();
    }

    @Override
    public void unlink(FsEntryName name) throws IOException {
        this.autoSync(name, null);
        if (name.isRoot()) {
            FsArchiveFileSystem<E> fileSystem;
            try {
                fileSystem = this.autoMount();
            }
            catch (FsFalsePositiveException ex) {
                try {
                    this.sync(UNLINK_SYNC_OPTIONS);
                }
                catch (IOException cannotHappen) {
                    throw new AssertionError((Object)cannotHappen);
                }
                throw ex;
            }
            if (!fileSystem.getEntry(FsEntryName.ROOT).getMembers().isEmpty()) {
                throw new IOException("root directory not empty");
            }
            if (1 < fileSystem.getSize()) {
                logger.log(Level.WARNING, "unlink.absolute", new Object[]{fileSystem.getSize() - 1, this.getModel().getMountPoint()});
            }
            this.sync(UNLINK_SYNC_OPTIONS);
        } else {
            this.autoMount().unlink(name);
        }
    }

    abstract boolean autoSync(FsEntryName var1, @CheckForNull Entry.Access var2) throws FsSyncException, FsException;

    private static class ProxyEntry
    extends DecoratingEntry<FsArchiveEntry>
    implements FsArchiveEntry {
        ProxyEntry(FsArchiveEntry entry) {
            super(entry);
        }

        @Override
        public Entry.Type getType() {
            return ((FsArchiveEntry)this.delegate).getType();
        }

        @Override
        public boolean setSize(Entry.Size type, long value) {
            return ((FsArchiveEntry)this.delegate).setSize(type, value);
        }

        @Override
        public boolean setTime(Entry.Access type, long value) {
            return ((FsArchiveEntry)this.delegate).setTime(type, value);
        }
    }

    private final class Output
    extends OutputSocket<FsArchiveEntry> {
        final FsEntryName name;
        final BitField<FsOutputOption> options;
        @CheckForNull
        final Entry template;

        Output(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            this.name = name;
            this.options = options;
            this.template = template;
        }

        FsArchiveFileSystemOperation<E> mknod() throws IOException {
            FsArchiveController.this.autoSync(this.name, Entry.Access.WRITE);
            return FsArchiveController.this.autoMount(!this.name.isRoot() && this.options.get(FsOutputOption.CREATE_PARENTS), this.options).mknod(this.name, Entry.Type.FILE, this.options, this.template);
        }

        @Override
        public FsArchiveEntry getLocalTarget() throws IOException {
            Object entry = ((FsCovariantEntry)this.mknod().getTarget()).getEntry();
            if (this.options.get(FsOutputOption.APPEND)) {
                return new ProxyEntry((FsArchiveEntry)entry);
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() throws IOException {
            FsArchiveFileSystemOperation mknod = this.mknod();
            Object entry = ((FsCovariantEntry)mknod.getTarget()).getEntry();
            OutputSocket<FsArchiveEntry> socket = FsArchiveController.this.getOutputSocket(entry);
            InputStream in = null;
            if (this.options.get(FsOutputOption.APPEND)) {
                try {
                    in = FsArchiveController.this.getInputSocket(entry.getName()).newInputStream();
                }
                catch (FileNotFoundException ex) {
                    logger.log(Level.WARNING, ex.toString(), ex);
                }
            }
            try {
                OutputStream out = socket.bind(null == in ? this : null).newOutputStream();
                try {
                    mknod.run();
                    if (in != null) {
                        Streams.cat(in, out);
                    }
                }
                catch (IOException ex) {
                    out.close();
                    throw ex;
                }
                OutputStream outputStream = out;
                return outputStream;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        throw new InputException(ex);
                    }
                }
            }
        }
    }

    private final class Input
    extends InputSocket<FsArchiveEntry> {
        final FsEntryName name;

        Input(FsEntryName name) {
            this.name = name;
        }

        @Override
        public FsArchiveEntry getLocalTarget() throws IOException {
            FsCovariantEntry entry;
            if (!FsArchiveController.this.autoSync(this.name, Entry.Access.READ)) {
                FsArchiveController.this.autoMount();
                this.getPeerTarget();
            }
            if (null == (entry = FsArchiveController.this.autoMount().getEntry(this.name))) {
                throw new FsEntryNotFoundException((FsModel)FsArchiveController.this.getModel(), this.name, "no such file or directory");
            }
            return entry.getEntry();
        }

        InputSocket<?> getBoundSocket() throws IOException {
            FsArchiveEntry entry = this.getLocalTarget();
            if (Entry.Type.FILE != entry.getType()) {
                throw new FsEntryNotFoundException((FsModel)FsArchiveController.this.getModel(), this.name, "cannot read directories");
            }
            return FsArchiveController.this.getInputSocket(entry.getName()).bind(this);
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return this.getBoundSocket().newReadOnlyFile();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.getBoundSocket().newInputStream();
        }
    }
}

