/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileInputStream;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class InputSocket<E extends Entry>
extends IOSocket<E, Entry> {
    @CheckForNull
    private OutputSocket<?> peer;

    @Override
    @Nullable
    public Entry getPeerTarget() throws IOException {
        return null == this.peer ? null : (Entry)this.peer.getLocalTarget();
    }

    public final InputSocket<E> bind(@CheckForNull InputSocket<?> to) {
        this.peer = null == to ? null : to.peer;
        return this;
    }

    final InputSocket<E> connect(@CheckForNull OutputSocket<?> newPeer) {
        OutputSocket<?> oldPeer = this.peer;
        if (oldPeer != newPeer) {
            this.peer = null;
            if (null != oldPeer) {
                oldPeer.connect(null);
            }
            this.peer = newPeer;
            if (null != newPeer) {
                newPeer.connect(this);
            }
        }
        return this;
    }

    public SeekableByteChannel newSeekableByteChannel() throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract ReadOnlyFile newReadOnlyFile() throws IOException;

    public InputStream newInputStream() throws IOException {
        return new ReadOnlyFileInputStream(this.newReadOnlyFile());
    }
}

