/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.util.QuotedUriSyntaxException;
import de.schlichtherle.truezip.util.UriBuilder;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public enum FsUriModifier {
    NULL{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            if (uri.normalize() != uri) {
                throw new QuotedUriSyntaxException(uri, "URI path not in normal form");
            }
            return uri;
        }
    }
    ,
    CANONICALIZE{

        @Override
        URI modify(URI uri, PostFix fix) throws URISyntaxException {
            return fix.modify(uri.normalize());
        }
    };


    abstract URI modify(URI var1, PostFix var2) throws URISyntaxException;

    @Immutable
    public static enum PostFix {
        PATH{

            @Override
            @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
            URI modify(URI uri) throws URISyntaxException {
                String ssp;
                int l;
                int i;
                String p;
                if (uri.isOpaque() || !uri.isAbsolute() || null != uri.getRawFragment()) {
                    return uri;
                }
                String s = uri.getScheme();
                String a = uri.getRawAuthority();
                String q = p = uri.getRawPath();
                if (p.startsWith("//") && 2 <= (i = p.indexOf(47, 2))) {
                    a = p.substring(2, i);
                    p = p.substring(i);
                }
                while (p.endsWith("/") && (1 <= (l = p.length()) && null == s || 2 <= l && ':' != p.charAt(l - 2) || 3 <= l && !p.startsWith("/") || 4 < l && p.startsWith("/") || null != a)) {
                    p = p.substring(0, l - 1);
                }
                return p == q && (null != a || null == (ssp = uri.getRawSchemeSpecificPart()) || !ssp.startsWith("//")) ? uri : new UriBuilder(uri, true).authority(a).path(p).getUri();
            }
        }
        ,
        MOUNT_POINT{

            @Override
            URI modify(URI uri) {
                return uri;
            }
        }
        ,
        ENTRY_NAME{

            @Override
            @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
            URI modify(URI uri) throws URISyntaxException {
                String p;
                if (uri.isAbsolute() || null != uri.getRawAuthority() || null != uri.getRawFragment()) {
                    return uri;
                }
                String q = p = uri.getRawPath();
                while (p.startsWith("/")) {
                    p = p.substring(1);
                }
                while (p.endsWith("/")) {
                    p = p.substring(0, p.length() - 1);
                }
                return p == q ? uri : new UriBuilder(uri, true).path(p).getUri();
            }
        };


        abstract URI modify(URI var1) throws URISyntaxException;
    }
}

