/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsException;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNotSyncedException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsOutputOptions;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncWarningException;
import de.schlichtherle.truezip.fs.archive.FsArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemEvent;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemTouchListener;
import de.schlichtherle.truezip.fs.archive.FsCacheableFalsePositiveException;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.FsFileSystemArchiveController;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.Paths;
import de.schlichtherle.truezip.socket.DecoratingInputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputShop;
import de.schlichtherle.truezip.socket.DelegatingOutputSocket;
import de.schlichtherle.truezip.socket.DisconnectingInputShop;
import de.schlichtherle.truezip.socket.DisconnectingOutputShop;
import de.schlichtherle.truezip.socket.IOSocket;
import de.schlichtherle.truezip.socket.InputService;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputService;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.socket.SynchronizedInputShop;
import de.schlichtherle.truezip.socket.SynchronizedOutputShop;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class FsDefaultArchiveController<E extends FsArchiveEntry>
extends FsFileSystemArchiveController<E> {
    private static final BitField<FsInputOption> MOUNT_INPUT_OPTIONS = BitField.of(FsInputOption.CACHE);
    private final FsArchiveDriver<E> driver;
    private final FsController<?> parent;
    private final FsEntryName target;
    @CheckForNull
    private InputArchive<E> inputArchive;
    @CheckForNull
    private OutputArchive<E> outputArchive;
    private final FsArchiveFileSystemTouchListener<E> touchListener = new TouchListener();

    FsDefaultArchiveController(FsConcurrentModel model, FsController<?> parent, FsArchiveDriver<E> driver) {
        super(model);
        if (null == driver) {
            throw new NullPointerException();
        }
        if (model.getParent() != parent.getModel()) {
            throw new IllegalArgumentException("Parent/member mismatch!");
        }
        this.driver = driver;
        this.parent = parent;
        this.target = this.getMountPoint().getPath().getEntryName();
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.driver);
        assert (null != this.parent);
        assert (null != this.target);
        return true;
    }

    @CheckForNull
    private InputArchive<E> getInputArchive() {
        return this.inputArchive;
    }

    private void setInputArchive(@CheckForNull InputArchive<E> inputArchive) {
        this.inputArchive = inputArchive;
        if (null != inputArchive) {
            this.setTouched(true);
        }
    }

    @CheckForNull
    private OutputArchive<E> getOutputArchive() {
        return this.outputArchive;
    }

    private void setOutputArchive(@CheckForNull OutputArchive<E> outputArchive) {
        this.outputArchive = outputArchive;
        if (null != outputArchive) {
            this.setTouched(true);
        }
    }

    @Override
    public FsController<?> getParent() {
        return this.parent;
    }

    @Override
    public Icon getOpenIcon() throws IOException {
        this.autoMount();
        return this.driver.getOpenIcon((FsModel)this.getModel());
    }

    @Override
    public Icon getClosedIcon() throws IOException {
        this.autoMount();
        return this.driver.getClosedIcon((FsModel)this.getModel());
    }

    @Override
    void mount(boolean autoCreate) throws IOException {
        try {
            boolean readOnly = !this.parent.isWritable(this.target);
            InputSocket<?> socket = this.driver.getInputSocket(this.parent, this.target, MOUNT_INPUT_OPTIONS);
            InputArchive<E> ia = new InputArchive<E>(this.driver.newInputShop((FsModel)this.getModel(), socket));
            this.setInputArchive(ia);
            this.setFileSystem(FsArchiveFileSystem.newPopulatedFileSystem(this.driver, ia.getDriverProduct(), (Entry)socket.getLocalTarget(), readOnly));
        }
        catch (FsException ex) {
            throw ex;
        }
        catch (IOException ex) {
            if (!autoCreate) {
                FsEntry parentEntry;
                try {
                    parentEntry = this.parent.getEntry(this.target);
                }
                catch (FsException ex2) {
                    assert (false);
                    throw ex2;
                }
                catch (IOException ex2) {
                    throw new FsFalsePositiveException(ex2);
                }
                if (null != parentEntry && !parentEntry.isType(Entry.Type.SPECIAL)) {
                    throw new FsCacheableFalsePositiveException(ex);
                }
                throw new FsFalsePositiveException(ex);
            }
            if (null != this.parent.getEntry(this.target)) {
                throw new FsCacheableFalsePositiveException(ex);
            }
            this.makeOutput();
            this.setFileSystem(FsArchiveFileSystem.newEmptyFileSystem(this.driver));
        }
        this.getFileSystem().addFsArchiveFileSystemTouchListener(this.touchListener);
    }

    private OutputArchive<E> makeOutput() throws IOException {
        OutputArchive<E> oa = this.getOutputArchive();
        if (null != oa) {
            return oa;
        }
        BitField<FsOutputOption> options = this.getContext().getOutputOptions().and(FsOutputOptions.OUTPUT_PREFERENCES_MASK).set(FsOutputOption.CACHE);
        OutputSocket<?> socket = this.driver.getOutputSocket(this.parent, this.target, options, null);
        InputArchive<E> ia = this.getInputArchive();
        oa = new OutputArchive<E>(this.driver.newOutputShop((FsModel)this.getModel(), socket, null == ia ? null : ia.getDriverProduct()));
        this.setOutputArchive(oa);
        return oa;
    }

    @Override
    InputSocket<?> getInputSocket(String name) {
        InputArchive<E> ia = this.getInputArchive();
        assert (null != ia);
        return ia.getInputSocket(name);
    }

    @Override
    OutputSocket<?> getOutputSocket(E entry) {
        class Output
        extends DelegatingOutputSocket<Entry> {
            final /* synthetic */ FsArchiveEntry val$entry;

            Output() {
                this.val$entry = fsArchiveEntry;
            }

            @Override
            protected OutputSocket<? extends Entry> getDelegate() throws IOException {
                return FsDefaultArchiveController.this.makeOutput().getOutputSocket(this.val$entry);
            }
        }
        return new Output();
    }

    @Override
    void checkAccess(FsEntryName name, @CheckForNull Entry.Access intention) throws FsNotSyncedException {
        FsArchiveEntry iae;
        InputArchive<E> ia;
        FsArchiveEntry oae;
        String aen;
        FsCovariantEntry ce;
        FsArchiveFileSystem f = this.getFileSystem();
        if (null == f || null == (ce = f.getEntry(name))) {
            return;
        }
        Boolean grow = null;
        OutputArchive<E> oa = this.getOutputArchive();
        if (null != oa) {
            aen = ce.getEntry().getName();
            oae = (FsArchiveEntry)oa.getEntry(aen);
            if (null != oae && (!(grow = Boolean.valueOf(this.getContext().get(FsOutputOption.GROW))).booleanValue() || null == intention && !this.driver.getRedundantMetaDataSupport() || Entry.Access.WRITE == intention && !this.driver.getRedundantContentSupport())) {
                throw new FsNotSyncedException();
            }
        } else {
            aen = null;
            oae = null;
        }
        if (null != (ia = this.getInputArchive())) {
            if (null == aen) {
                aen = ce.getEntry().getName();
            }
            if (null != (iae = (FsArchiveEntry)ia.getEntry(aen)) && (Boolean.FALSE.equals(grow) || null == grow && !this.getContext().get(FsOutputOption.GROW))) {
                return;
            }
        } else {
            iae = null;
        }
        if (Entry.Access.READ == intention && (null == iae || iae != oae && oae != null)) {
            throw new FsNotSyncedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends IOException> void sync(BitField<FsSyncOption> options, ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (!this.isFileSystemTouched() || null != this.getOutputArchive());
        try {
            if (!options.get(FsSyncOption.ABORT_CHANGES) && this.isFileSystemTouched()) {
                this.performSync(handler);
            }
        }
        finally {
            try {
                this.commitSync(handler);
            }
            finally {
                assert (null == this.getFileSystem());
                assert (null == this.getInputArchive());
                assert (null == this.getOutputArchive());
                if (options.get(FsSyncOption.ABORT_CHANGES) || options.get(FsSyncOption.CLEAR_CACHE)) {
                    this.setTouched(false);
                }
            }
        }
    }

    private <X extends IOException> void performSync(final ExceptionHandler<? super FsSyncException, X> handler) throws X {
        assert (this.isFileSystemTouched());
        OutputArchive<E> oa = this.getOutputArchive();
        assert (null != oa);
        InputArchive<E> ia = this.getInputArchive();
        class FilterExceptionHandler
        implements ExceptionHandler<IOException, X> {
            IOException last;

            FilterExceptionHandler() {
            }

            @Override
            public X fail(IOException cause) {
                this.last = cause;
                return (IOException)handler.fail(new FsSyncException((FsModel)FsDefaultArchiveController.this.getModel(), cause));
            }

            @Override
            public void warn(IOException cause) throws IOException {
                assert (null != cause);
                IOException old = this.last;
                this.last = cause;
                if (null != old || !(cause instanceof InputException)) {
                    throw (IOException)handler.fail(new FsSyncException((FsModel)FsDefaultArchiveController.this.getModel(), cause));
                }
                handler.warn(new FsSyncWarningException((FsModel)FsDefaultArchiveController.this.getModel(), cause));
            }
        }
        FsDefaultArchiveController.copy(this.getFileSystem(), null == ia ? new DummyInputArchive() : ia.getDriverProduct(), oa.getDriverProduct(), new FilterExceptionHandler());
    }

    private static <E extends FsArchiveEntry, X extends IOException> void copy(FsArchiveFileSystem<E> fileSystem, InputService<E> input, OutputService<E> output, ExceptionHandler<IOException, X> handler) throws X {
        for (FsCovariantEntry<E> ce : fileSystem) {
            for (FsArchiveEntry ae : ce.getEntries()) {
                String aen = ae.getName();
                if (null != output.getEntry(aen)) continue;
                try {
                    if (Entry.Type.DIRECTORY == ae.getType()) {
                        if (Paths.isRoot(ce.getName()) || -1L == ae.getTime(Entry.Access.WRITE)) continue;
                        output.getOutputSocket(ae).newOutputStream().close();
                        continue;
                    }
                    if (null != input.getEntry(aen)) {
                        IOSocket.copy(input.getInputSocket(aen), output.getOutputSocket(ae));
                        continue;
                    }
                    output.getOutputSocket(ae).newOutputStream().close();
                }
                catch (IOException ex) {
                    handler.warn(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X extends IOException> void commitSync(ExceptionHandler<? super FsSyncException, X> handler) throws X {
        this.setFileSystem(null);
        try {
            InputArchive<E> ia = this.getInputArchive();
            this.setInputArchive(null);
            if (null != ia) {
                try {
                    ia.close();
                }
                catch (IOException ex) {
                    handler.warn(new FsSyncWarningException((FsModel)this.getModel(), ex));
                }
            }
        }
        finally {
            OutputArchive<E> oa = this.getOutputArchive();
            this.setOutputArchive(null);
            if (null != oa) {
                try {
                    oa.close();
                }
                catch (IOException ex) {
                    throw (IOException)handler.fail(new FsSyncException((FsModel)this.getModel(), ex));
                }
            }
        }
    }

    private boolean isFileSystemTouched() {
        FsArchiveFileSystem fileSystem = this.getFileSystem();
        return null != fileSystem && fileSystem.isTouched();
    }

    private final class TouchListener
    implements FsArchiveFileSystemTouchListener<E> {
        private TouchListener() {
        }

        @Override
        public void beforeTouch(FsArchiveFileSystemEvent<? extends E> event) throws IOException {
            assert (event.getSource() == FsDefaultArchiveController.this.getFileSystem());
            FsDefaultArchiveController.this.makeOutput();
            assert (FsDefaultArchiveController.this.isTouched());
        }

        @Override
        public void afterTouch(FsArchiveFileSystemEvent<? extends E> event) {
            assert (event.getSource() == FsDefaultArchiveController.this.getFileSystem());
        }
    }

    private static final class OutputArchive<E extends FsArchiveEntry>
    extends DecoratingOutputShop<E, OutputShop<E>> {
        final OutputShop<E> driverProduct;

        OutputArchive(OutputShop<E> driverProduct) {
            super(new DisconnectingOutputShop<E>(new SynchronizedOutputShop<E>(driverProduct)));
            this.driverProduct = driverProduct;
        }

        OutputShop<E> getDriverProduct() {
            return this.driverProduct;
        }
    }

    private static final class InputArchive<E extends FsArchiveEntry>
    extends DecoratingInputShop<E, InputShop<E>> {
        final InputShop<E> driverProduct;

        InputArchive(InputShop<E> driverProduct) {
            super(new DisconnectingInputShop<E>(new SynchronizedInputShop<E>(driverProduct)));
            this.driverProduct = driverProduct;
        }

        InputShop<E> getDriverProduct() {
            return this.driverProduct;
        }
    }

    private static final class DummyInputArchive<E extends Entry>
    implements InputService<E> {
        private DummyInputArchive() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public E getEntry(String name) {
            return null;
        }

        @Override
        public InputSocket<? extends E> getInputSocket(String name) {
            throw new UnsupportedOperationException();
        }
    }
}

