/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsResourceAccountant;
import de.schlichtherle.truezip.io.SequentialIOExceptionBuilder;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@DefaultAnnotation(value={NonNull.class})
public class FsResourceAccountantTest {
    private static long TIMEOUT_MILLIS = 100L;
    private Lock lock;
    private FsResourceAccountant accountant;

    @Before
    public void setUp() {
        this.lock = new ReentrantLock();
        this.accountant = new FsResourceAccountant(this.lock);
    }

    @After
    public void tearDown() {
        System.gc();
    }

    @Test
    public void testAccounting() throws IOException {
        Resource resource = new Resource();
        this.accountant.startAccountingFor((Closeable)resource);
        resource.close();
        this.accountant.startAccountingFor((Closeable)resource);
        resource.close();
        this.accountant.stopAccountingFor((Closeable)resource);
        resource.close();
        this.accountant.stopAccountingFor((Closeable)resource);
    }

    @Test
    public void testWaitForCurrentThread() throws InterruptedException {
        Resource resource = new Resource();
        this.accountant.startAccountingFor((Closeable)resource);
        long time = System.currentTimeMillis();
        int resources = this.accountant.waitOtherThreads(TIMEOUT_MILLIS);
        Assert.assertTrue((String)"Timeout!", (System.currentTimeMillis() < time + TIMEOUT_MILLIS ? 1 : 0) != 0);
        Assert.assertThat((Object)resources, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testWaitForOtherThreads() throws InterruptedException {
        Thread[] threads = new Thread[]{new ResourceHog(), new EvilResourceHog()};
        for (int i = 0; i < threads.length; ++i) {
            Class<?> clazz = threads[i].getClass();
            threads[i].start();
            threads[i].join();
            threads[i] = null;
            System.gc();
            long time = System.currentTimeMillis();
            int resources = this.accountant.waitOtherThreads(TIMEOUT_MILLIS);
            Assert.assertTrue((String)("Timeout waiting for " + clazz.getName()), (System.currentTimeMillis() < time + TIMEOUT_MILLIS ? 1 : 0) != 0);
            Assert.assertThat((Object)resources, (Matcher)CoreMatchers.is((Object)0));
        }
    }

    @Test
    public void testCloseAll() throws IOException, InterruptedException {
        Thread[] threads;
        for (Thread thread : threads = new Thread[]{new ResourceHog(), new EvilResourceHog()}) {
            thread.start();
            thread.join();
        }
        long time = System.currentTimeMillis();
        int resources = this.accountant.waitOtherThreads(TIMEOUT_MILLIS);
        Assert.assertTrue((String)"No timeout!", (System.currentTimeMillis() >= time + TIMEOUT_MILLIS ? 1 : 0) != 0);
        Assert.assertThat((Object)resources, (Matcher)CoreMatchers.is((Object)2));
        this.accountant.closeAllResources((ExceptionHandler)SequentialIOExceptionBuilder.create());
        time = System.currentTimeMillis();
        resources = this.accountant.waitOtherThreads(TIMEOUT_MILLIS);
        Assert.assertTrue((String)"Timeout!", (System.currentTimeMillis() < time + TIMEOUT_MILLIS ? 1 : 0) != 0);
        Assert.assertThat((Object)resources, (Matcher)CoreMatchers.is((Object)0));
    }

    private class Resource
    implements Closeable {
        private Resource() {
        }

        @Override
        public void close() {
        }
    }

    private final class EvilResourceHog
    extends Thread {
        final Resource resource;

        private EvilResourceHog() {
            this.resource = new Resource();
        }

        @Override
        public void run() {
            FsResourceAccountantTest.this.accountant.startAccountingFor((Closeable)this.resource);
            FsResourceAccountantTest.this.accountant.startAccountingFor((Closeable)this.resource);
        }
    }

    private final class ResourceHog
    extends Thread {
        private ResourceHog() {
        }

        @Override
        public void run() {
            Resource resource = new Resource();
            FsResourceAccountantTest.this.accountant.startAccountingFor((Closeable)resource);
            FsResourceAccountantTest.this.accountant.startAccountingFor((Closeable)resource);
        }
    }
}

