/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.rof;

import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.IntervalReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFileTestSuite;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Before;

public final class IntervalReadOnlyFileTest
extends ReadOnlyFileTestSuite {
    private static final Logger logger = Logger.getLogger(IntervalReadOnlyFileTest.class.getName());
    private File temp2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Before
    public void setUp() throws IOException {
        this.temp2 = File.createTempFile("tzp", null);
        try {
            FileOutputStream out = new FileOutputStream(this.temp2);
            try {
                ((OutputStream)out).write(DATA);
                ((OutputStream)out).write(DATA);
                ((OutputStream)out).write(DATA);
            }
            finally {
                ((OutputStream)out).close();
            }
            assert ((long)(3 * DATA.length) == this.temp2.length());
        }
        catch (IOException ex) {
            if (!this.temp2.delete()) {
                logger.log(Level.WARNING, "{0} (File.delete() failed)", this.temp2);
            }
            throw ex;
        }
        super.setUp();
    }

    @Override
    protected ReadOnlyFile newReadOnlyFile(File file) throws IOException {
        DefaultReadOnlyFile rof = new DefaultReadOnlyFile(this.temp2);
        rof.seek((long)DATA.length);
        return new IntervalReadOnlyFile((ReadOnlyFile)rof, (long)DATA.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void tearDown() throws IOException {
        try {
            super.tearDown();
        }
        finally {
            if (this.temp2.exists() && !this.temp2.delete()) {
                logger.log(Level.WARNING, "{0} (could not delete)", this.temp2);
            }
        }
    }
}

