/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UriBuilderTest {
    private static final Logger logger = Logger.getLogger(UriBuilderTest.class.getName());
    private UriBuilder builder;

    @Before
    public void setUp() {
        this.builder = new UriBuilder();
    }

    @Test
    public void testDefaults() {
        Assert.assertNull((Object)this.builder.getScheme());
        Assert.assertNull((Object)this.builder.getAuthority());
        Assert.assertNull((Object)this.builder.getPath());
        Assert.assertNull((Object)this.builder.getQuery());
        Assert.assertNull((Object)this.builder.getFragment());
        Assert.assertEquals((Object)"", (Object)this.builder.toString());
        Assert.assertEquals((Object)URI.create(""), (Object)this.builder.toUri());
    }

    @Test
    public void testClear1() {
        this.builder.uri(URI.create("scheme://authority/path?query#fragment")).clear();
        this.testDefaults();
    }

    @Test
    public void testClear2() {
        this.builder.uri(URI.create("scheme://authority/path?query#fragment")).scheme(null).authority(null).path(null).query(null).fragment(null);
        this.testDefaults();
    }

    @Test
    public void testRoundTrip() {
        for (String[] test : new String[][]{{"scheme://authority/path?query#fragment", "scheme", "authority", "/path", "query", "fragment"}, {"foo%3Abar", null, null, "foo:bar", null, null}, {"/foo:bar", null, null, "/foo:bar", null, null}, {"//foo:bar", null, "foo:bar", "", null, null}, {"//foo:bar/", null, "foo:bar", "/", null, null}, {"foo:bar", "foo", null, "bar", null, null}, {"", null, null, "", null, null}, {"?query", null, null, "", "query", null}, {"#foo?bar%23baz", null, null, "", null, "foo?bar#baz"}, {"?foo?bar%23baz#foo?bar%23baz", null, null, "", "foo?bar#baz", "foo?bar#baz"}, {"0", null, null, "0", null, null}, {"0%3A", null, null, "0:", null, null}, {"scheme:scheme-specific-part#fragment", "scheme", null, "scheme-specific-part", null, "fragment"}, {"scheme:scheme-specific-part?noquery#fragment", "scheme", null, "scheme-specific-part?noquery", null, "fragment"}, {"scheme:?#", "scheme", null, "?", null, ""}, {"scheme:?", "scheme", null, "?", null, null}, {"f\u00f6\u00f6%20b\u00e4r", null, null, "f\u00f6\u00f6 b\u00e4r", null, null}, {"foo:b\u00e4r", "foo", null, "b\u00e4r", null, null}, {"Dichtheitspr\u00fcfung%3A%C2%A0Moenikes%20l\u00e4sst%20Dampf%20ab", null, null, "Dichtheitspr\u00fcfung:\u00a0Moenikes l\u00e4sst Dampf ab", null, null}}) {
            URI u = URI.create(test[0]);
            this.builder.setUri(u);
            Assert.assertEquals((Object)test[1], (Object)this.builder.getScheme());
            Assert.assertEquals((Object)test[2], (Object)this.builder.getAuthority());
            Assert.assertEquals((Object)test[3], (Object)this.builder.getPath());
            Assert.assertEquals((Object)test[4], (Object)this.builder.getQuery());
            Assert.assertEquals((Object)test[5], (Object)this.builder.getFragment());
            Assert.assertEquals((Object)test[0], (Object)this.builder.toString());
            this.builder.clear().scheme(test[1]).authority(test[2]).path(test[3]).query(test[4]).fragment(test[5]);
            Assert.assertEquals((Object)test[0], (Object)this.builder.toString());
            Assert.assertEquals((Object)u, (Object)this.builder.toUri());
            Assert.assertEquals((Object)u, (Object)this.builder.uri(u).toUri());
        }
    }

    @Test
    public void testIllegalState() {
        for (String[] test : new String[][]{{"", null, null, null, null}, {"0", null, null, null, null}, {"+", null, null, null, null}, {"-", null, null, null, null}, {".", null, null, null, null}, {"a$", null, null, null, null}, {"scheme", null, null, null, null}, {"scheme", null, null, null, "fragment"}, {"scheme", null, "", null, null}, {"scheme", null, "", null, "fragment"}, {null, "", "path", null, null}, {null, "", "path", null, "fragment"}, {null, "", "path", "query", null}, {null, "", "path", "query", "fragment"}, {"scheme", "", "path", "query", "fragment"}, {null, "authority", "path", null, null}, {null, "authority", "path", null, "fragment"}, {null, "authority", "path", "query", null}, {null, "authority", "path", "query", "fragment"}, {"scheme", "authority", "path", "query", "fragment"}, {"scheme", null, null, "query", null}, {"scheme", null, null, "query", "fragment"}, {"scheme", null, "path", "query", null}, {"scheme", null, "path", "query", "fragment"}}) {
            this.builder.clear().scheme(test[0]).authority(test[1]).path(test[2]).query(test[3]).fragment(test[4]);
            try {
                this.builder.getString();
                Assert.fail();
            }
            catch (URISyntaxException expected) {
                logger.log(Level.FINE, expected.toString(), expected);
            }
            try {
                this.builder.toString();
                Assert.fail();
            }
            catch (IllegalStateException expected) {
                // empty catch block
            }
            try {
                this.builder.getUri();
                Assert.fail();
            }
            catch (URISyntaxException expected) {
                // empty catch block
            }
            try {
                this.builder.toUri();
                Assert.fail();
            }
            catch (IllegalStateException expected) {
                // empty catch block
            }
            this.builder.uri(URI.create(""));
            Assert.assertEquals((Object)"", (Object)this.builder.toString());
            Assert.assertEquals((Object)URI.create(""), (Object)this.builder.toUri());
        }
    }
}

